/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class BuildCompletionScheduler
implements Consumer<Runnable>,
AutoCloseable {
    private final JobScheduler jobScheduler;
    private final List<JobHandle<?>> handles = new ArrayList();

    public BuildCompletionScheduler(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    @Override
    public void accept(Runnable runnable) {
        this.handles.add(this.jobScheduler.schedule(Group.INDEX_POPULATION, runnable));
    }

    @Override
    public void close() {
        try {
            for (JobHandle<?> handle : this.handles) {
                handle.waitTermination();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

