/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.batchimport.api.Configuration;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.helpers.progress.ProgressListener;

public interface RecordIdIterator {
    public PrimitiveLongCollections.RangedLongIterator nextBatch();

    public static RecordIdIterator backwards(long lowIncluded, long highExcluded, Configuration config) {
        return new Backwards(lowIncluded, highExcluded, config);
    }

    public static RecordIdIterator forwards(long lowIncluded, long highExcluded, Configuration config) {
        return new Forwards(lowIncluded, highExcluded, config);
    }

    public static RecordIdIterator withProgress(RecordIdIterator iterator, final ProgressListener progressListener) {
        return () -> {
            final PrimitiveLongCollections.RangedLongIterator actual = iterator.nextBatch();
            if (actual == null) {
                return null;
            }
            return new PrimitiveLongCollections.RangedLongIterator(){

                public long startInclusive() {
                    return actual.startInclusive();
                }

                public long endExclusive() {
                    return actual.endExclusive();
                }

                public long next() {
                    progressListener.add(1L);
                    return actual.next();
                }

                public boolean hasNext() {
                    return actual.hasNext();
                }
            };
        };
    }

    public static class Backwards
    implements RecordIdIterator {
        private final long lowIncluded;
        private final long highExcluded;
        private final int batchSize;
        private long endId;

        public Backwards(long lowIncluded, long highExcluded, Configuration config) {
            this.lowIncluded = lowIncluded;
            this.highExcluded = highExcluded;
            this.batchSize = config.batchSize();
            this.endId = highExcluded;
        }

        @Override
        public PrimitiveLongCollections.RangedLongIterator nextBatch() {
            if (this.endId <= this.lowIncluded) {
                return null;
            }
            long startId = this.findFloorId(this.endId);
            PrimitiveLongCollections.RangedLongIterator result = PrimitiveLongCollections.range((long)startId, (long)(this.endId - 1L));
            this.endId = Long.max(this.lowIncluded, startId);
            return result;
        }

        private long findFloorId(long roofId) {
            int rest = (int)(roofId % (long)this.batchSize);
            return Long.max(rest == 0 ? roofId - (long)this.batchSize : roofId - (long)rest, this.lowIncluded);
        }

        public String toString() {
            return "]" + this.highExcluded + "-" + this.lowIncluded + "]";
        }
    }

    public static class Forwards
    implements RecordIdIterator {
        private final long lowIncluded;
        private final long highExcluded;
        private final int batchSize;
        private long startId;

        public Forwards(long lowIncluded, long highExcluded, Configuration config) {
            this.lowIncluded = lowIncluded;
            this.highExcluded = highExcluded;
            this.batchSize = config.batchSize();
            this.startId = lowIncluded;
        }

        @Override
        public PrimitiveLongCollections.RangedLongIterator nextBatch() {
            if (this.startId >= this.highExcluded) {
                return null;
            }
            long endId = Long.min(this.highExcluded, this.findRoofId(this.startId));
            PrimitiveLongCollections.RangedLongIterator result = PrimitiveLongCollections.range((long)this.startId, (long)(endId - 1L));
            this.startId = endId;
            return result;
        }

        private long findRoofId(long floorId) {
            int rest = (int)(floorId % (long)this.batchSize);
            return Long.max(rest == 0 ? floorId + (long)this.batchSize : floorId + (long)this.batchSize - (long)rest, this.lowIncluded);
        }

        public String toString() {
            return "[" + this.lowIncluded + "-" + this.highExcluded + "[";
        }
    }
}

