/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.io.pagecache.PageCursor;

class GenerationSafePointerPair {
    static final int SIZE = 24;
    static final String GENERATION_COMPARISON_NAME_B_BIG = "A < B";
    static final String GENERATION_COMPARISON_NAME_A_BIG = "A > B";
    static final String GENERATION_COMPARISON_NAME_EQUAL = "A == B";
    static final byte STABLE = 0;
    static final byte UNSTABLE = 1;
    static final byte CRASH = 2;
    static final byte BROKEN = 3;
    static final byte EMPTY = 4;
    static final long FLAG_SUCCESS = 0L;
    static final long FLAG_FAIL = Long.MIN_VALUE;
    static final long FLAG_READ = 0L;
    static final long FLAG_WRITE = 0x4000000000000000L;
    static final long FLAG_GENERATION_EQUAL = 0L;
    static final long FLAG_GENERATION_A_BIG = 0x800000000000000L;
    static final long FLAG_GENERATION_B_BIG = 0x1000000000000000L;
    static final long FLAG_SLOT_A = 0L;
    static final long FLAG_SLOT_B = 0x2000000000000000L;
    static final int SHIFT_STATE_A = 56;
    static final int SHIFT_STATE_B = 53;
    static final long SUCCESS_WRITE_TO_B = 0x6000000000000000L;
    static final long SUCCESS_WRITE_TO_A = 0x4000000000000000L;
    static final long SUCCESS_MASK = Long.MIN_VALUE;
    static final long READ_OR_WRITE_MASK = 0x4000000000000000L;
    static final long SLOT_MASK = 0x2000000000000000L;
    static final long STATE_MASK = 7L;
    static final long GENERATION_COMPARISON_MASK = 0x1800000000000000L;
    static final long POINTER_MASK = 0xFFFFFFFFFFFFL;
    static final GenerationTarget NO_GENERATION_TARGET = generation -> {};

    private GenerationSafePointerPair() {
    }

    public static long read(PageCursor cursor, long stableGeneration, long unstableGeneration, GenerationTarget generationTarget) {
        short checksumA;
        long generationA = GenerationSafePointer.readGeneration(cursor);
        long pointerA = GenerationSafePointer.readPointer(cursor);
        short readChecksumA = GenerationSafePointer.readChecksum(cursor);
        boolean correctChecksumA = readChecksumA == (checksumA = GenerationSafePointer.checksumOf(generationA, pointerA));
        long generationB = GenerationSafePointer.readGeneration(cursor);
        long pointerB = GenerationSafePointer.readPointer(cursor);
        short readChecksumB = GenerationSafePointer.readChecksum(cursor);
        short checksumB = GenerationSafePointer.checksumOf(generationB, pointerB);
        boolean correctChecksumB = readChecksumB == checksumB;
        byte pointerStateA = GenerationSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationA, pointerA, correctChecksumA);
        byte pointerStateB = GenerationSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationB, pointerB, correctChecksumB);
        if (pointerStateA == 1) {
            if (pointerStateB == 0 || pointerStateB == 4) {
                return GenerationSafePointerPair.buildSuccessfulReadResult(0L, generationA, pointerA, generationTarget);
            }
        } else if (pointerStateB == 1) {
            if (pointerStateA == 0 || pointerStateA == 4) {
                return GenerationSafePointerPair.buildSuccessfulReadResult(0x2000000000000000L, generationB, pointerB, generationTarget);
            }
        } else if (pointerStateA == 0 && pointerStateB == 0) {
            if (generationA > generationB) {
                return GenerationSafePointerPair.buildSuccessfulReadResult(0L, generationA, pointerA, generationTarget);
            }
            if (generationB > generationA) {
                return GenerationSafePointerPair.buildSuccessfulReadResult(0x2000000000000000L, generationB, pointerB, generationTarget);
            }
        } else {
            if (pointerStateA == 0) {
                return GenerationSafePointerPair.buildSuccessfulReadResult(0L, generationA, pointerA, generationTarget);
            }
            if (pointerStateB == 0) {
                return GenerationSafePointerPair.buildSuccessfulReadResult(0x2000000000000000L, generationB, pointerB, generationTarget);
            }
        }
        generationTarget.accept(0L);
        return Long.MIN_VALUE | GenerationSafePointerPair.generationState(generationA, generationB) | (long)pointerStateA << 56 | (long)pointerStateB << 53;
    }

    private static long buildSuccessfulReadResult(long slot, long generation, long pointer, GenerationTarget generationTarget) {
        generationTarget.accept(generation);
        return 0L | slot | pointer;
    }

    public static long write(PageCursor cursor, long pointer, long stableGeneration, long unstableGeneration) {
        byte pointerStateB;
        short checksumA;
        int offset = cursor.getOffset();
        pointer = GenerationSafePointerPair.pointer(pointer);
        long generationA = GenerationSafePointer.readGeneration(cursor);
        long pointerA = GenerationSafePointer.readPointer(cursor);
        short readChecksumA = GenerationSafePointer.readChecksum(cursor);
        boolean correctChecksumA = readChecksumA == (checksumA = GenerationSafePointer.checksumOf(generationA, pointerA));
        long generationB = GenerationSafePointer.readGeneration(cursor);
        long pointerB = GenerationSafePointer.readPointer(cursor);
        short readChecksumB = GenerationSafePointer.readChecksum(cursor);
        short checksumB = GenerationSafePointer.checksumOf(generationB, pointerB);
        boolean correctChecksumB = readChecksumB == checksumB;
        byte pointerStateA = GenerationSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationA, pointerA, correctChecksumA);
        long writeResult = GenerationSafePointerPair.writeResult(pointerStateA, pointerStateB = GenerationSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationB, pointerB, correctChecksumB), generationA, generationB);
        if (GenerationSafePointerPair.isSuccess(writeResult)) {
            boolean writeToA = (writeResult & 0x2000000000000000L) == 0L;
            int writeOffset = writeToA ? offset : offset + 12;
            cursor.setOffset(writeOffset);
            GenerationSafePointer.write(cursor, unstableGeneration, pointer);
        }
        return writeResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long writeResult(byte pointerStateA, byte pointerStateB, long generationA, long generationB) {
        if (pointerStateA == 0) {
            if (pointerStateB != 0) return 0x6000000000000000L;
            if (generationA > generationB) {
                return 0x6000000000000000L;
            }
            if (generationB <= generationA) return 0xC000000000000000L | GenerationSafePointerPair.generationState(generationA, generationB) | (long)pointerStateA << 56 | (long)pointerStateB << 53;
            return 0x4000000000000000L;
        }
        if (pointerStateB == 0) {
            return 0x4000000000000000L;
        }
        if (pointerStateA == 1) {
            if (pointerStateB != 4) return 0xC000000000000000L | GenerationSafePointerPair.generationState(generationA, generationB) | (long)pointerStateA << 56 | (long)pointerStateB << 53;
            return 0x4000000000000000L;
        }
        if (pointerStateB == 1) {
            if (pointerStateA != 4) return 0xC000000000000000L | GenerationSafePointerPair.generationState(generationA, generationB) | (long)pointerStateA << 56 | (long)pointerStateB << 53;
            return 0x6000000000000000L;
        }
        if (pointerStateA != 4 || pointerStateB != 4) return 0xC000000000000000L | GenerationSafePointerPair.generationState(generationA, generationB) | (long)pointerStateA << 56 | (long)pointerStateB << 53;
        return 0x4000000000000000L;
    }

    private static long generationState(long generationA, long generationB) {
        return generationA > generationB ? 0x800000000000000L : (generationB > generationA ? 0x1000000000000000L : 0L);
    }

    static byte pointerState(long stableGeneration, long unstableGeneration, long generation, long pointer, boolean checksumIsCorrect) {
        if (GenerationSafePointer.isEmpty(generation, pointer)) {
            return 4;
        }
        if (!checksumIsCorrect) {
            return 3;
        }
        if (generation < 1L) {
            return 3;
        }
        if (generation <= stableGeneration) {
            return 0;
        }
        if (generation == unstableGeneration) {
            return 1;
        }
        return 2;
    }

    static boolean isSuccess(long result) {
        return (result & Long.MIN_VALUE) == 0L;
    }

    static long pointer(long readResult) {
        return readResult & 0xFFFFFFFFFFFFL;
    }

    static String failureDescription(long result) {
        return "GSPP " + (GenerationSafePointerPair.isRead(result) ? "READ" : "WRITE") + " failure" + String.format("%n  Pointer state A: %s", GenerationSafePointerPair.pointerStateName(GenerationSafePointerPair.pointerStateFromResult(result, 56))) + String.format("%n  Pointer state B: %s", GenerationSafePointerPair.pointerStateName(GenerationSafePointerPair.pointerStateFromResult(result, 53))) + String.format("%n  Generations: " + GenerationSafePointerPair.generationComparisonFromResult(result), new Object[0]);
    }

    static boolean assertSuccess(long result) {
        if (!GenerationSafePointerPair.isSuccess(result)) {
            throw new TreeInconsistencyException(GenerationSafePointerPair.failureDescription(result), new Object[0]);
        }
        return true;
    }

    private static String generationComparisonFromResult(long result) {
        long bits = result & 0x1800000000000000L;
        if (bits == 0L) {
            return GENERATION_COMPARISON_NAME_EQUAL;
        }
        if (bits == 0x800000000000000L) {
            return GENERATION_COMPARISON_NAME_A_BIG;
        }
        if (bits == 0x1000000000000000L) {
            return GENERATION_COMPARISON_NAME_B_BIG;
        }
        return "Unknown[" + bits + "]";
    }

    static String pointerStateName(byte pointerState) {
        switch (pointerState) {
            case 0: {
                return "STABLE";
            }
            case 1: {
                return "UNSTABLE";
            }
            case 2: {
                return "CRASH";
            }
            case 3: {
                return "BROKEN";
            }
            case 4: {
                return "EMPTY";
            }
        }
        return "Unknown[" + pointerState + "]";
    }

    static byte pointerStateFromResult(long result, int shift) {
        return (byte)(result >>> shift & 7L);
    }

    static boolean isRead(long result) {
        return (result & 0x4000000000000000L) == 0L;
    }

    static boolean resultIsFromSlotA(long result) {
        return (result & 0x2000000000000000L) == 0L;
    }

    @FunctionalInterface
    static interface GenerationTarget {
        public void accept(long var1);
    }
}

