/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.OffloadStore;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.index.internal.gbptree.TreeNodeFixedSize;

class TreeNodeSelector {
    private static final Factory FIXED = new Factory(){

        @Override
        public <KEY, VALUE> TreeNode<KEY, VALUE> create(int pageSize, Layout<KEY, VALUE> layout, OffloadStore<KEY, VALUE> offloadStore) {
            return new TreeNodeFixedSize<KEY, VALUE>(pageSize, layout);
        }

        @Override
        public byte formatIdentifier() {
            return 2;
        }

        @Override
        public byte formatVersion() {
            return 0;
        }
    };
    private static final Factory DYNAMIC = new Factory(){

        @Override
        public <KEY, VALUE> TreeNode<KEY, VALUE> create(int pageSize, Layout<KEY, VALUE> layout, OffloadStore<KEY, VALUE> offloadStore) {
            return new TreeNodeDynamicSize<KEY, VALUE>(pageSize, layout, offloadStore);
        }

        @Override
        public byte formatIdentifier() {
            return 3;
        }

        @Override
        public byte formatVersion() {
            return 0;
        }
    };

    TreeNodeSelector() {
    }

    static Factory selectByLayout(Layout<?, ?> layout) {
        return layout.fixedSize() ? FIXED : DYNAMIC;
    }

    static Factory selectByFormat(byte formatIdentifier, byte formatVersion) {
        if (formatIdentifier == 2 && formatVersion == 0) {
            return FIXED;
        }
        if (formatIdentifier == 3 && formatVersion == 0) {
            return DYNAMIC;
        }
        throw new IllegalArgumentException(String.format("Unknown format identifier:%d and version:%d combination", formatIdentifier, formatVersion));
    }

    static interface Factory {
        public <KEY, VALUE> TreeNode<KEY, VALUE> create(int var1, Layout<KEY, VALUE> var2, OffloadStore<KEY, VALUE> var3);

        public byte formatIdentifier();

        public byte formatVersion();
    }
}

