/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.io.pagecache.PageCursor;

class PageCursorUtil {
    static final short _1B_MASK = 255;
    static final int _2B_MASK = 65535;
    static final int _3B_MASK = 0xFFFFFF;
    static final long _4B_MASK = 0xFFFFFFFFL;
    static final long _6B_MASK = 0xFFFFFFFFFFFFL;

    private PageCursorUtil() {
    }

    static void put6BLong(PageCursor cursor, long value) {
        if ((value & 0xFFFF000000000000L) != 0L) {
            throw new IllegalArgumentException("Illegal 6B value " + value);
        }
        int lsb = (int)value;
        short msb = (short)(value >>> 32);
        cursor.putInt(lsb);
        cursor.putShort(msb);
    }

    static long get6BLong(PageCursor cursor) {
        long lsb = PageCursorUtil.getUnsignedInt(cursor);
        long msb = PageCursorUtil.getUnsignedShort(cursor);
        return lsb | msb << 32;
    }

    static void put3BInt(PageCursor cursor, int value) {
        int offset = cursor.getOffset();
        PageCursorUtil.put3BInt(cursor, offset, value);
        cursor.setOffset(offset + 3);
    }

    static void put3BInt(PageCursor cursor, int offset, int value) {
        if ((value & 0xFF000000) != 0) {
            throw new IllegalArgumentException("Illegal 3B value " + value);
        }
        short lsb = (short)value;
        byte msb = (byte)(value >>> 16);
        cursor.putShort(offset, lsb);
        cursor.putByte(offset + 2, msb);
    }

    static int get3BInt(PageCursor cursor) {
        int offset = cursor.getOffset();
        int result = PageCursorUtil.get3BInt(cursor, offset);
        cursor.setOffset(offset + 3);
        return result;
    }

    public static int get3BInt(PageCursor cursor, int offset) {
        int lsb = PageCursorUtil.getUnsignedShort(cursor, offset);
        int msb = PageCursorUtil.getUnsignedByte(cursor, offset + 2);
        return lsb | msb << 16;
    }

    static void putUnsignedShort(PageCursor cursor, int value) {
        int offset = cursor.getOffset();
        PageCursorUtil.putUnsignedShort(cursor, offset, value);
        cursor.setOffset(offset + 2);
    }

    static void putUnsignedShort(PageCursor cursor, int offset, int value) {
        if ((value & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("Illegal 2B value " + value);
        }
        cursor.putShort(offset, (short)value);
    }

    static int getUnsignedShort(PageCursor cursor) {
        return cursor.getShort() & 0xFFFF;
    }

    static int getUnsignedShort(PageCursor cursor, int offset) {
        return cursor.getShort(offset) & 0xFFFF;
    }

    static long getUnsignedInt(PageCursor cursor) {
        return (long)cursor.getInt() & 0xFFFFFFFFL;
    }

    static int getUnsignedByte(PageCursor cursor, int offset) {
        return cursor.getByte(offset) & 0xFF;
    }

    static void checkOutOfBounds(PageCursor cursor) {
        if (cursor.checkAndClearBoundsFlag()) {
            throw new TreeInconsistencyException("Some internal problem causing out of bounds: pageId:" + cursor.getCurrentPageId(), new Object[0]);
        }
    }

    static void goTo(PageCursor cursor, String messageOnError, long pageId) throws IOException {
        if (!cursor.next(pageId)) {
            throw new IllegalStateException("Could not go to page:" + pageId + " [" + messageOnError + "]");
        }
    }
}

