/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.index.internal.gbptree.DefaultTreeNodeSelector;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.RootLayerConfiguration;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.util.Preconditions;

public class Meta {
    static final byte CURRENT_STATE_VERSION = 0;
    static final byte CURRENT_GBPTREE_VERSION = 0;
    public static final int META_SIZE = 40;
    private static final int MASK_BYTE = 255;
    private static final int SHIFT_DATA_FORMAT_IDENTIFIER = 0;
    private static final int SHIFT_DATA_FORMAT_VERSION = 8;
    private static final int SHIFT_ROOT_FORMAT_IDENTIFIER = 16;
    private static final int SHIFT_ROOT_FORMAT_VERSION = 24;
    static final byte UNUSED_VERSION = 0;
    private final byte dataFormatIdentifier;
    private final byte dataFormatVersion;
    private final byte rootFormatIdentifier;
    private final byte rootFormatVersion;
    private final int payloadSize;
    private final long dataLayoutIdentifier;
    private final int dataLayoutMajorVersion;
    private final int dataLayoutMinorVersion;
    private final long rootLayoutIdentifier;
    private final int rootLayoutMajorVersion;
    private final int rootLayoutMinorVersion;

    private Meta(byte dataFormatIdentifier, byte dataFormatVersion, byte rootFormatIdentifier, byte rootFormatVersion, int payloadSize, long dataLayoutIdentifier, int dataLayoutMajorVersion, int dataLayoutMinorVersion, long rootLayoutIdentifier, int rootLayoutMajorVersion, int rootLayoutMinorVersion) {
        this.dataFormatIdentifier = dataFormatIdentifier;
        this.dataFormatVersion = dataFormatVersion;
        this.rootFormatIdentifier = rootFormatIdentifier;
        this.rootFormatVersion = rootFormatVersion;
        this.payloadSize = payloadSize;
        this.dataLayoutIdentifier = dataLayoutIdentifier;
        this.dataLayoutMajorVersion = dataLayoutMajorVersion;
        this.dataLayoutMinorVersion = dataLayoutMinorVersion;
        this.rootLayoutIdentifier = rootLayoutIdentifier;
        this.rootLayoutMajorVersion = rootLayoutMajorVersion;
        this.rootLayoutMinorVersion = rootLayoutMinorVersion;
    }

    static Meta from(int payloadSize, Layout<?, ?> dataLayout, Layout<?, ?> rootLayout, TreeNodeSelector treeNodeSelector) {
        TreeNodeSelector.Factory dataFormat = treeNodeSelector.selectByLayout(dataLayout);
        if (rootLayout != null) {
            TreeNodeSelector.Factory rootFormat = treeNodeSelector.selectByLayout(rootLayout);
            return new Meta(dataFormat.formatIdentifier(), dataFormat.formatVersion(), rootFormat.formatIdentifier(), rootFormat.formatVersion(), payloadSize, dataLayout.identifier(), dataLayout.majorVersion(), dataLayout.minorVersion(), rootLayout.identifier(), rootLayout.majorVersion(), rootLayout.minorVersion());
        }
        return new Meta(dataFormat.formatIdentifier(), dataFormat.formatVersion(), 0, 0, payloadSize, dataLayout.identifier(), dataLayout.majorVersion(), dataLayout.minorVersion(), 0L, 0, 0);
    }

    private static Meta parseMeta(int format, int payloadSize, long dataLayoutIdentifier, int dataLayoutMajorVersion, int dataLayoutMinorVersion, long rootLayoutIdentifier, int rootLayoutMajorVersion, int rootLayoutMinorVersion) {
        return new Meta(Meta.extractIndividualVersion(format, 0), Meta.extractIndividualVersion(format, 8), Meta.extractIndividualVersion(format, 16), Meta.extractIndividualVersion(format, 24), payloadSize, dataLayoutIdentifier, dataLayoutMajorVersion, dataLayoutMinorVersion, rootLayoutIdentifier, rootLayoutMajorVersion, rootLayoutMinorVersion);
    }

    public static Meta read(ByteBuffer buffer) {
        Preconditions.checkState((buffer.remaining() >= 40 ? 1 : 0) != 0, (String)"Not enough data");
        int format = buffer.getInt();
        int payloadSize = buffer.getInt();
        long dataLayoutIdentifier = buffer.getLong();
        int dataLayoutMajorVersion = buffer.getInt();
        int dataLayoutMinorVersion = buffer.getInt();
        long rootLayoutIdentifier = buffer.getLong();
        int rootLayoutMajorVersion = buffer.getInt();
        int rootLayoutMinorVersion = buffer.getInt();
        return Meta.parseMeta(format, payloadSize, dataLayoutIdentifier, dataLayoutMajorVersion, dataLayoutMinorVersion, rootLayoutIdentifier, rootLayoutMajorVersion, rootLayoutMinorVersion);
    }

    static Meta read(PageCursor cursor) throws IOException {
        byte[] buffer = new byte[40];
        do {
            cursor.getBytes(buffer);
        } while (cursor.shouldRetry());
        return Meta.read(ByteBuffer.wrap(buffer).order(cursor.getByteOrder()));
    }

    public void verify(Layout<?, ?> dataLayout, RootLayerConfiguration<?> rootLayerConfiguration) {
        this.verify(dataLayout, rootLayerConfiguration.rootLayout(), DefaultTreeNodeSelector.selector());
    }

    public void verify(Layout<?, ?> dataLayout, Layout<?, ?> rootLayout, TreeNodeSelector treeNodeSelector) {
        if (rootLayout != null) {
            TreeNodeSelector.Factory rootFormat = treeNodeSelector.selectByLayout(rootLayout);
            if (rootFormat.formatIdentifier() != this.rootFormatIdentifier || rootFormat.formatVersion() != this.rootFormatVersion) {
                throw new MetadataMismatchException(String.format("Tried to open using root layout not compatible with what tree was created with. Created with formatIdentifier:%d,formatVersion:%d. Opened with formatIdentifier:%d,formatVersion%d", this.rootFormatIdentifier, this.rootFormatVersion, rootFormat.formatIdentifier(), rootFormat.formatVersion()));
            }
        } else {
            if (this.rootFormatIdentifier != 0) {
                throw new MetadataMismatchException("Unexpected version " + this.rootFormatIdentifier + " for version slot 3");
            }
            if (this.rootFormatVersion != 0) {
                throw new MetadataMismatchException("Unexpected version " + this.rootFormatVersion + " for version slot 4");
            }
        }
        if (!dataLayout.compatibleWith(this.dataLayoutIdentifier, this.dataLayoutMajorVersion, this.dataLayoutMinorVersion)) {
            throw new MetadataMismatchException(String.format("Tried to open using data layout not compatible with what the index was created with. Created with: layoutIdentifier=%d,majorVersion=%d,minorVersion=%d. Opened with layoutIdentifier=%d,majorVersion=%d,minorVersion=%d", this.dataLayoutIdentifier, this.dataLayoutMajorVersion, this.dataLayoutMinorVersion, dataLayout.identifier(), dataLayout.majorVersion(), dataLayout.minorVersion()));
        }
        if (rootLayout != null && !rootLayout.compatibleWith(this.rootLayoutIdentifier, this.rootLayoutMajorVersion, this.rootLayoutMinorVersion)) {
            throw new MetadataMismatchException(String.format("Tried to open using root layout not compatible with what the index was created with. Created with: layoutIdentifier=%d,majorVersion=%d,minorVersion=%d. Opened with layoutIdentifier=%d,majorVersion=%d,minorVersion=%d", this.rootLayoutIdentifier, this.rootLayoutMajorVersion, this.rootLayoutMinorVersion, rootLayout.identifier(), rootLayout.majorVersion(), rootLayout.minorVersion()));
        }
        TreeNodeSelector.Factory dataFormatByLayout = treeNodeSelector.selectByLayout(dataLayout);
        if (dataFormatByLayout.formatIdentifier() != this.dataFormatIdentifier || dataFormatByLayout.formatVersion() != this.dataFormatVersion) {
            throw new MetadataMismatchException(String.format("Tried to open using data layout not compatible with what tree was created with. Created with formatIdentifier:%d,formatVersion:%d. Opened with formatIdentifier:%d,formatVersion%d", this.dataFormatIdentifier, this.dataFormatVersion, dataFormatByLayout.formatIdentifier(), dataFormatByLayout.formatVersion()));
        }
    }

    void write(PageCursor cursor) {
        cursor.putInt(this.allVersionsCombined());
        cursor.putInt(this.getPayloadSize());
        cursor.putLong(this.getDataLayoutIdentifier());
        cursor.putInt(this.getDataLayoutMajorVersion());
        cursor.putInt(this.getDataLayoutMinorVersion());
        cursor.putLong(this.getRootLayoutIdentifier());
        cursor.putInt(this.getRootLayoutMajorVersion());
        cursor.putInt(this.getRootLayoutMinorVersion());
        PointerChecking.checkOutOfBounds(cursor);
    }

    private static byte extractIndividualVersion(int format, int shift) {
        return (byte)(format >>> shift & 0xFF);
    }

    private int allVersionsCombined() {
        return this.dataFormatIdentifier << 0 | this.dataFormatVersion << 8 | this.rootFormatIdentifier << 16 | this.rootFormatVersion << 24;
    }

    public int getPayloadSize() {
        return this.payloadSize;
    }

    byte getDataFormatIdentifier() {
        return this.dataFormatIdentifier;
    }

    byte getDataFormatVersion() {
        return this.dataFormatVersion;
    }

    byte getRootFormatIdentifier() {
        return this.rootFormatIdentifier;
    }

    byte getRootFormatVersion() {
        return this.rootFormatVersion;
    }

    long getDataLayoutIdentifier() {
        return this.dataLayoutIdentifier;
    }

    int getDataLayoutMajorVersion() {
        return this.dataLayoutMajorVersion;
    }

    int getDataLayoutMinorVersion() {
        return this.dataLayoutMinorVersion;
    }

    long getRootLayoutIdentifier() {
        return this.rootLayoutIdentifier;
    }

    int getRootLayoutMajorVersion() {
        return this.rootLayoutMajorVersion;
    }

    int getRootLayoutMinorVersion() {
        return this.rootLayoutMinorVersion;
    }
}

