/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import org.neo4j.common.DependencyResolver;
import org.neo4j.index.internal.gbptree.KeyLayout;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MultiRootLayer;
import org.neo4j.index.internal.gbptree.RootLayer;
import org.neo4j.index.internal.gbptree.RootLayerSupport;
import org.neo4j.index.internal.gbptree.RootMappingLayout;
import org.neo4j.index.internal.gbptree.SingleRoot;
import org.neo4j.index.internal.gbptree.SingleRootLayer;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class RootLayerConfiguration<ROOT_KEY> {
    public static RootLayerConfiguration<SingleRoot> singleRoot() {
        return new SingleRootLayerConfiguration();
    }

    public static <ROOT_KEY> RootLayerConfiguration<ROOT_KEY> multipleRoots(KeyLayout<ROOT_KEY> rootKeyLayout, int rootMappingCacheSize) {
        return new MultiRootLayerConfiguration<ROOT_KEY>(rootKeyLayout, rootMappingCacheSize);
    }

    abstract <VALUE, KEY> RootLayer<ROOT_KEY, KEY, VALUE> buildRootLayer(RootLayerSupport var1, Layout<KEY, VALUE> var2, TreeNodeSelector var3, DependencyResolver var4) throws IOException;

    abstract Layout<ROOT_KEY, RootMappingLayout.RootMappingValue> rootLayout();

    static final class SingleRootLayerConfiguration
    extends RootLayerConfiguration<SingleRoot> {
        SingleRootLayerConfiguration() {
        }

        @Override
        <VALUE, KEY> RootLayer<SingleRoot, KEY, VALUE> buildRootLayer(RootLayerSupport rootLayerSupport, Layout<KEY, VALUE> dataLayout, TreeNodeSelector treeNodeSelector, DependencyResolver dependencyResolver) {
            return new SingleRootLayer<KEY, VALUE>(rootLayerSupport, dataLayout, treeNodeSelector, dependencyResolver);
        }

        @Override
        Layout<SingleRoot, RootMappingLayout.RootMappingValue> rootLayout() {
            return null;
        }
    }

    static final class MultiRootLayerConfiguration<ROOT_KEY>
    extends RootLayerConfiguration<ROOT_KEY> {
        private final Layout<ROOT_KEY, RootMappingLayout.RootMappingValue> rootKeyLayout;
        private final int rootMappingCacheSize;

        MultiRootLayerConfiguration(KeyLayout<ROOT_KEY> rootKeyLayout, int rootMappingCacheSize) {
            this.rootKeyLayout = new RootMappingLayout<ROOT_KEY>(rootKeyLayout);
            this.rootMappingCacheSize = rootMappingCacheSize;
        }

        @Override
        <VALUE, KEY> RootLayer<ROOT_KEY, KEY, VALUE> buildRootLayer(RootLayerSupport rootLayerSupport, Layout<KEY, VALUE> dataLayout, TreeNodeSelector treeNodeSelector, DependencyResolver dependencyResolver) {
            return new MultiRootLayer<ROOT_KEY, KEY, VALUE>(rootLayerSupport, this.rootKeyLayout, dataLayout, this.rootMappingCacheSize, treeNodeSelector, dependencyResolver);
        }

        @Override
        Layout<ROOT_KEY, RootMappingLayout.RootMappingValue> rootLayout() {
            return this.rootKeyLayout;
        }
    }
}

