/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public abstract class RecoveryCleanupWorkCollector
extends LifecycleAdapter {
    private static ImmediateRecoveryCleanupWorkCollector immediateInstance;
    private static IgnoringRecoveryCleanupWorkCollector ignoringInstance;

    abstract void add(CleanupJob var1);

    static void executeWithExecutor(CleanupJobGroupAction action) {
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        try {
            action.execute(executor);
        }
        finally {
            RecoveryCleanupWorkCollector.shutdownExecutorAndVerifyNoLeaks(executor);
        }
    }

    private static void shutdownExecutorAndVerifyNoLeaks(ExecutorService executor) {
        List<Runnable> leakedTasks = executor.shutdownNow();
        if (!leakedTasks.isEmpty()) {
            throw new IllegalStateException("Tasks leaked from CleanupJob. Tasks where " + String.valueOf(leakedTasks));
        }
    }

    public static RecoveryCleanupWorkCollector immediate() {
        if (immediateInstance == null) {
            immediateInstance = new ImmediateRecoveryCleanupWorkCollector();
        }
        return immediateInstance;
    }

    public static RecoveryCleanupWorkCollector ignore() {
        if (ignoringInstance == null) {
            ignoringInstance = new IgnoringRecoveryCleanupWorkCollector();
        }
        return ignoringInstance;
    }

    @FunctionalInterface
    static interface CleanupJobGroupAction {
        public void execute(ExecutorService var1);
    }

    static class ImmediateRecoveryCleanupWorkCollector
    extends RecoveryCleanupWorkCollector {
        ImmediateRecoveryCleanupWorkCollector() {
        }

        @Override
        public void add(CleanupJob job) {
            ImmediateRecoveryCleanupWorkCollector.executeWithExecutor(executor -> {
                try {
                    job.run(new CleanupJob.Executor(){

                        @Override
                        public <T> CleanupJob.JobResult<T> submit(String jobDescription, Callable<T> job) {
                            Future<T> future = executor.submit(job);
                            return future::get;
                        }
                    });
                }
                finally {
                    job.close();
                }
            });
        }
    }

    static class IgnoringRecoveryCleanupWorkCollector
    extends RecoveryCleanupWorkCollector {
        IgnoringRecoveryCleanupWorkCollector() {
        }

        @Override
        public void add(CleanupJob job) {
            job.close();
        }
    }
}

