/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn.swapper;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.neo4j.internal.nativeimpl.NativeAccessFactory;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.impl.muninn.EvictionBouncer;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.impl.muninn.swapper.BlockSwapper;
import org.neo4j.io.pagecache.impl.muninn.swapper.FallbackBlockSwapper;
import org.neo4j.io.pagecache.impl.muninn.swapper.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.swapper.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.swapper.SingleFilePageSwapper;
import org.neo4j.io.pagecache.impl.muninn.swapper.UnsafeBlockSwapper;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class SingleFilePageSwapperFactory
implements PageSwapperFactory {
    private final FileSystemAbstraction fs;
    private final PageCacheTracer pageCacheTracer;
    private final BlockSwapper blockSwapper;
    private final boolean doForceOperations;

    public SingleFilePageSwapperFactory(FileSystemAbstraction fs, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        this(fs, pageCacheTracer, memoryTracker, true);
    }

    public SingleFilePageSwapperFactory(FileSystemAbstraction fs, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, boolean doForceOperations) {
        this.fs = fs;
        this.pageCacheTracer = pageCacheTracer;
        this.blockSwapper = SingleFilePageSwapperFactory.createBlockSwapper(memoryTracker);
        this.doForceOperations = doForceOperations;
    }

    @Override
    public PageSwapper createPageSwapper(Path file, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist, boolean useDirectIO, IOController ioController, EvictionBouncer evictionBouncer, SwapperSet swappers) throws IOException {
        if (!createIfNotExist && !this.fs.fileExists(file)) {
            throw new NoSuchFileException(file.toString(), null, "Cannot map non-existing file");
        }
        return new SingleFilePageSwapper(file, this.fs, filePageSize, onEviction, useDirectIO, ioController, swappers, this.pageCacheTracer.createFileSwapperTracer(), this.blockSwapper, this.nativeAccessFactory(), evictionBouncer, this.doForceOperations);
    }

    private static BlockSwapper createBlockSwapper(MemoryTracker memoryTracker) {
        if (UnsafeUtil.unsafeByteBufferAccessAvailable()) {
            return new UnsafeBlockSwapper();
        }
        return new FallbackBlockSwapper(memoryTracker);
    }

    @VisibleForTesting
    protected NativeAccessFactory nativeAccessFactory() {
        return file -> NativeAccessProvider.getNativeAccess();
    }
}

