/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.WrappingFileHandle;

public final class StreamFilesRecursive {
    private StreamFilesRecursive() {
    }

    public static Stream<FileHandle> streamFilesRecursive(FileSystemAbstraction fs, Path path, boolean includeDirectories) throws IOException {
        Path canonicalizedDirectory = path.toAbsolutePath().normalize();
        Stream snapshot = StreamFilesRecursive.streamFilesRecursiveInner(fs, canonicalizedDirectory, includeDirectories).toList().stream();
        return snapshot.map(f -> new WrappingFileHandle((Path)f, canonicalizedDirectory, fs));
    }

    private static Stream<Path> streamFilesRecursiveInner(FileSystemAbstraction fs, Path path, boolean includeDirectories) throws IOException {
        if (!fs.fileExists(path)) {
            return Stream.empty();
        }
        if (!fs.isDirectory(path)) {
            return Stream.of(path);
        }
        Stream<Path> recurse = Arrays.stream(fs.listFiles(path)).flatMap(IOUtils.uncheckedFunction(f -> StreamFilesRecursive.streamFilesRecursiveInner(fs, f, includeDirectories)));
        return includeDirectories ? Stream.concat(Stream.of(path), recurse) : recurse;
    }
}

