/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public final class HeapScopedBuffer
implements ScopedBuffer {
    public static final HeapScopedBuffer EMPTY_BUFFER = new HeapScopedBuffer(ByteBuffers.allocate(0, ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE).asReadOnlyBuffer(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    private final ByteBuffer buffer;
    private final MemoryTracker memoryTracker;
    private boolean closed;

    public HeapScopedBuffer(int capacity, ByteOrder byteOrder, MemoryTracker memoryTracker) {
        this(ByteBuffers.allocate(capacity, byteOrder, memoryTracker), memoryTracker);
    }

    private HeapScopedBuffer(ByteBuffer buffer, MemoryTracker memoryTracker) {
        this.buffer = buffer;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void close() {
        if (!this.closed) {
            ByteBuffers.releaseBuffer(this.buffer, this.memoryTracker);
            this.closed = true;
        }
    }
}

