/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaUserDescription;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;

public abstract sealed class IndexEntryUpdate
permits TokenIndexEntryUpdate, ValueIndexEntryUpdate {
    private final long entityId;
    private final UpdateMode updateMode;
    private final IndexDescriptor indexKey;

    IndexEntryUpdate(long entityId, IndexDescriptor indexKey, UpdateMode updateMode) {
        this.entityId = entityId;
        this.indexKey = indexKey;
        this.updateMode = updateMode;
    }

    public final long getEntityId() {
        return this.entityId;
    }

    public UpdateMode updateMode() {
        return this.updateMode;
    }

    public IndexDescriptor indexKey() {
        return this.indexKey;
    }

    public boolean equals(Object o) {
        boolean schemaEquals;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexEntryUpdate that = (IndexEntryUpdate)o;
        if (this.entityId != that.entityId) {
            return false;
        }
        if (this.updateMode != that.updateMode) {
            return false;
        }
        boolean bl = this.indexKey != null ? this.indexKey.equals((Object)that.indexKey) : (schemaEquals = that.indexKey == null);
        if (!schemaEquals) {
            return false;
        }
        return this.valueEquals(that);
    }

    public int hashCode() {
        int result = Long.hashCode(this.entityId);
        result = 31 * result + (this.updateMode != null ? this.updateMode.hashCode() : 0);
        result = 31 * result + (this.indexKey != null ? this.indexKey.hashCode() : 0);
        result = 31 * result + this.valueHash();
        return result;
    }

    public String describe(TokenNameLookup tokenNameLookup) {
        return String.format(this.getClass().getSimpleName() + "[id=%d, mode=%s, %s, %s]", new Object[]{this.entityId, this.updateMode, this.indexKey().schema().userDescription(tokenNameLookup), this.valueToString()});
    }

    public abstract long roughSizeOfUpdate();

    protected abstract boolean valueEquals(IndexEntryUpdate var1);

    protected abstract int valueHash();

    protected abstract String valueToString();

    public abstract IndexEntryUpdate withEntityId(long var1);

    public String toString() {
        return this.describe(SchemaUserDescription.TOKEN_ID_NAME_LOOKUP);
    }
}

