/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;

public class UniquePropertyValueValidationException
extends ConstraintValidationException {
    private final Set<IndexEntryConflictException> conflicts;

    private UniquePropertyValueValidationException(ErrorGqlStatusObject gqlStatusObject, IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Set<IndexEntryConflictException> conflicts, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, (ConstraintDescriptor)constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data", (Throwable)UniquePropertyValueValidationException.buildCauseChain(conflicts), tokenNameLookup);
        this.conflicts = conflicts;
    }

    private static IndexEntryConflictException buildCauseChain(Set<IndexEntryConflictException> conflicts) {
        IndexEntryConflictException chainedConflicts = null;
        for (IndexEntryConflictException conflict : conflicts) {
            chainedConflicts = (IndexEntryConflictException)Exceptions.chain(chainedConflicts, (Throwable)conflict);
        }
        return chainedConflicts;
    }

    private UniquePropertyValueValidationException(ErrorGqlStatusObject gqlStatusObject, IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Throwable cause, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, (ConstraintDescriptor)constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data", cause, tokenNameLookup);
        this.conflicts = Collections.emptySet();
    }

    public static UniquePropertyValueValidationException propertyUniquenessViolation(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Exception cause, TokenNameLookup tokenNameLookup) {
        Exception exception = cause;
        Objects.requireNonNull(exception);
        Exception exception2 = exception;
        int n = 0;
        String causeMessage = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{KernelException.class, Exception.class}, (Object)exception2, n)) {
            case 0 -> {
                KernelException ke = (KernelException)exception2;
                yield ke.getUserMessage(tokenNameLookup);
            }
            default -> {
                Exception e = exception2;
                yield e.getMessage();
            }
        };
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N79).withParam(GqlParams.ListParam.reasonList, List.of(causeMessage)).build();
        return new UniquePropertyValueValidationException(gql, constraint, phase, cause, tokenNameLookup);
    }

    public static UniquePropertyValueValidationException propertyUniquenessViolation(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, IndexEntryConflictException conflict, TokenNameLookup tokenNameLookup) {
        return UniquePropertyValueValidationException.propertyUniquenessViolation(constraint, phase, Set.of(conflict), tokenNameLookup);
    }

    public static UniquePropertyValueValidationException propertyUniquenessViolation(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Set<IndexEntryConflictException> conflicts, TokenNameLookup tokenNameLookup) {
        ArrayList<String> reasonList = new ArrayList<String>();
        for (IndexEntryConflictException conflict : conflicts) {
            reasonList.add(conflict.getUserMessage(tokenNameLookup));
        }
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N79).withParam(GqlParams.ListParam.reasonList, reasonList).build();
        return new UniquePropertyValueValidationException(gql, constraint, phase, conflicts, tokenNameLookup);
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        Throwable cause = this.getCause();
        if (cause instanceof IndexEntryConflictException) {
            IndexEntryConflictException ignored = (IndexEntryConflictException)cause;
        } else {
            if (cause instanceof KernelException) {
                KernelException exc = (KernelException)cause;
                return exc.getUserMessage(tokenNameLookup);
            }
            if (cause instanceof Exception) {
                Exception exc = (Exception)cause;
                return exc.getMessage();
            }
        }
        StringBuilder message = new StringBuilder();
        boolean appendLine = false;
        for (IndexEntryConflictException conflict : this.conflicts) {
            if (appendLine) {
                message.append(System.lineSeparator());
            }
            message.append(conflict.getUserMessage(tokenNameLookup));
            appendLine = true;
        }
        return message.toString();
    }

    public Set<IndexEntryConflictException> conflicts() {
        return this.conflicts;
    }
}

