/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.vector;

import org.neo4j.kernel.api.vector.VectorDistanceFunction;
import org.neo4j.kernel.api.vector.VectorUtil;
import org.neo4j.values.VectorCandidate;

public enum GQLVectorDistanceFunction implements VectorDistanceFunction
{
    EUCLIDEAN{

        public float distance(VectorCandidate vector1, VectorCandidate vector2) {
            return VectorUtil.l2Distance(vector1, vector2);
        }
    }
    ,
    EUCLIDEAN_SQUARED{

        public float distance(VectorCandidate vector1, VectorCandidate vector2) {
            return VectorUtil.squareL2Distance(vector1, vector2);
        }
    }
    ,
    MANHATTAN{

        public float distance(VectorCandidate vector1, VectorCandidate vector2) {
            return VectorUtil.l1Distance(vector1, vector2);
        }
    }
    ,
    COSINE{

        public float distance(VectorCandidate vector1, VectorCandidate vector2) {
            return 1.0f - VectorUtil.cosine(vector1, vector2);
        }

        @Override
        public boolean valid(VectorCandidate vector) {
            return VectorUtil.valid(vector) && !VectorUtil.origin(vector);
        }
    }
    ,
    DOT{

        public float distance(VectorCandidate vector1, VectorCandidate vector2) {
            return -VectorUtil.dotProduct(vector1, vector2);
        }
    }
    ,
    HAMMING{

        public float distance(VectorCandidate vector1, VectorCandidate vector2) {
            return VectorUtil.hammingDistance(vector1, vector2);
        }
    };


    public boolean valid(VectorCandidate vector) {
        return VectorUtil.valid(vector);
    }
}

