/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.kernel.impl.index.IndexCounters;

public class DatabaseIndexStats
extends IndexMonitor.MonitorAdapter
implements IndexCounters {
    private final Map<IndexType, IndexTypeStats> stats;

    public DatabaseIndexStats() {
        EnumMap<IndexType, IndexTypeStats> stats = new EnumMap<IndexType, IndexTypeStats>(IndexType.class);
        for (IndexType indexType : IndexType.values()) {
            stats.put(indexType, new IndexTypeStats());
        }
        this.stats = Collections.unmodifiableMap(stats);
    }

    @Override
    public long getQueryCount(IndexType type) {
        return this.stats.get((Object)type).queried.longValue();
    }

    @Override
    public long getPopulationCount(IndexType type) {
        return this.stats.get((Object)type).populated.longValue();
    }

    @Override
    public long getTotalSize(IndexType type) {
        return this.stats.get((Object)type).totalSize.longValue();
    }

    public void reportQueryCount(IndexDescriptor descriptor, long queriesSinceLastReport) {
        this.stats.get((Object)descriptor.getIndexType()).queried.add(queriesSinceLastReport);
    }

    public void populationCompleteOn(IndexDescriptor descriptor) {
        this.stats.get((Object)descriptor.getIndexType()).populated.increment();
    }

    public void reportChangeInSize(IndexDescriptor descriptor, long changeInSizeSinceLastReport) {
        this.stats.get((Object)descriptor.getIndexType()).totalSize.add(changeInSizeSinceLastReport);
    }

    private static class IndexTypeStats {
        final LongAdder queried = new LongAdder();
        final LongAdder populated = new LongAdder();
        final LongAdder totalSize = new LongAdder();

        private IndexTypeStats() {
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public DatabaseIndexStats create();
    }
}

