/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.Path;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexProvider;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.token.TokenHolders;

public class VectorIndexProviderFactory
extends AbstractIndexProviderFactory<VectorIndexProvider> {
    private final VectorIndexVersion version;

    public VectorIndexProviderFactory(VectorIndexVersion version) {
        this.version = version;
    }

    @Override
    protected Class<?> loggingClass() {
        return VectorIndexProvider.class;
    }

    @Override
    public IndexProviderDescriptor descriptor() {
        return this.version.descriptor();
    }

    @Override
    protected VectorIndexProvider internalCreate(PageCache pageCache, FileSystemAbstraction fs, Monitors monitors, String monitorTag, Config config, DatabaseReadOnlyChecker readOnlyDatabaseChecker, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseLayout databaseLayout, InternalLogProvider logProvider, TokenHolders tokenHolders, JobScheduler scheduler, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, DependencyResolver dependencyResolver) {
        return new VectorIndexProvider(this.version, fs, DirectoryFactory.directoryFactory((FileSystemAbstraction)fs), IndexDirectoryStructure.directoriesByProvider((Path)databaseLayout.databaseDirectory()), monitors, config, readOnlyDatabaseChecker, scheduler, (LogProvider)logProvider);
    }
}

