/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.InternalRelationshipTypeIndexCursor;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipSelection;

public class DefaultNodeBasedRelationshipTypeIndexCursor
extends IndexCursor<IndexProgressor, DefaultNodeBasedRelationshipTypeIndexCursor>
implements InternalRelationshipTypeIndexCursor {
    private final DefaultNodeCursor nodeCursor;
    private final DefaultRelationshipTraversalCursor relationshipTraversalCursor;
    private Read read;
    private TxStateHolder txStateHolder;
    private AccessModeProvider accessModeProvider;
    private LongIterator addedRelationships;
    private LongSet removedNodes;
    private int type;
    private long relId = -1L;
    private RelationshipSelection selection;
    private long nodeFromIndex;
    private ReadState readState;

    protected DefaultNodeBasedRelationshipTypeIndexCursor(CursorPool<DefaultNodeBasedRelationshipTypeIndexCursor> pool, DefaultNodeCursor nodeCursor, DefaultRelationshipTraversalCursor relationshipTraversalCursor) {
        super(pool);
        this.nodeCursor = nodeCursor;
        this.relationshipTraversalCursor = relationshipTraversalCursor;
    }

    public void initializeQuery(IndexProgressor progressor, int type, IndexOrder order) {
        LongIterator addedRelationships = null;
        LongSet removedNodes = null;
        if (this.txStateHolder.hasTxStateWithChanges()) {
            addedRelationships = this.txStateHolder.txState().relationshipsWithTypeChanged(type).getAdded().freeze().longIterator();
            removedNodes = this.txStateHolder.txState().addedAndRemovedNodes().getRemoved().freeze();
        }
        this.initializeQuery(progressor, type, addedRelationships, removedNodes);
    }

    public void initializeQuery(IndexProgressor progressor, int type, LongIterator addedRelationships, LongSet removedNodes) {
        super.initialize(progressor);
        this.type = type;
        this.selection = RelationshipSelection.selection((int)type, (Direction)Direction.OUTGOING);
        this.addedRelationships = addedRelationships;
        this.removedNodes = removedNodes;
        ReadState readState = this.readState = addedRelationships != null ? ReadState.TXSTATE_READ : ReadState.INDEX_READ;
        if (this.tracer != null) {
            this.tracer.onRelationshipTypeScan(type);
        }
    }

    public boolean acceptEntity(long nodeId, int type) {
        if (type != this.type) {
            return false;
        }
        if (this.removedNodes != null && this.removedNodes.contains(nodeId)) {
            return false;
        }
        this.nodeFromIndex = nodeId;
        return true;
    }

    public boolean isClosed() {
        return this.isProgressorClosed();
    }

    public boolean next() {
        boolean hasNext = this.innerNext();
        if (hasNext && this.tracer != null) {
            this.tracer.onRelationship(this.relId);
        }
        return hasNext;
    }

    private boolean innerNext() {
        while (this.readState != ReadState.UNAVAILABLE) {
            switch (this.readState.ordinal()) {
                case 0: {
                    while (this.addedRelationships.hasNext()) {
                        long id = this.addedRelationships.next();
                        this.relationshipTraversalCursor.init(id, this.read, this.txStateHolder, this.accessModeProvider);
                        if (!this.relationshipTraversalCursor.next()) continue;
                        this.relId = id;
                        return true;
                    }
                    this.readState = ReadState.INDEX_READ;
                    break;
                }
                case 1: {
                    this.readState = this.indexNext() ? ReadState.NODE_READ : ReadState.UNAVAILABLE;
                    break;
                }
                case 2: {
                    this.nodeCursor.single(this.nodeFromIndex, this.read, this.txStateHolder, this.accessModeProvider);
                    if (this.nodeCursor.next()) {
                        this.nodeCursor.relationships(this.relationshipTraversalCursor, this.selection);
                        this.readState = ReadState.RELATIONSHIP_READ;
                        break;
                    }
                    this.readState = ReadState.INDEX_READ;
                    break;
                }
                case 3: {
                    while (this.relationshipTraversalCursor.next()) {
                        if (this.relationshipTraversalCursor.currentAddedInTx != -1L) continue;
                        this.relId = this.relationshipTraversalCursor.relationshipReference();
                        return true;
                    }
                    this.readState = ReadState.INDEX_READ;
                }
            }
        }
        this.relId = -1L;
        return false;
    }

    public float score() {
        return Float.NaN;
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        this.checkReadFromStore();
        this.relationshipTraversalCursor.properties(cursor, selection);
    }

    public Reference propertiesReference() {
        this.checkReadFromStore();
        return this.relationshipTraversalCursor.propertiesReference();
    }

    public long relationshipReference() {
        return this.relId;
    }

    public int type() {
        return this.type;
    }

    public void source(NodeCursor cursor) {
        this.read.singleNode(this.sourceNodeReference(), cursor);
    }

    public void target(NodeCursor cursor) {
        this.read.singleNode(this.targetNodeReference(), cursor);
    }

    public long sourceNodeReference() {
        this.checkReadFromStore();
        return this.relationshipTraversalCursor.sourceNodeReference();
    }

    public long targetNodeReference() {
        this.checkReadFromStore();
        return this.relationshipTraversalCursor.targetNodeReference();
    }

    public boolean readFromStore() {
        return this.relId != -1L;
    }

    @Override
    public void initState(Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.read = read;
        this.txStateHolder = txStateHolder;
        this.accessModeProvider = accessModeProvider;
    }

    private void checkReadFromStore() {
        if (this.relationshipTraversalCursor.relationshipReference() != this.relId) {
            throw new IllegalStateException("Relationship hasn't been read from store");
        }
    }

    @Override
    public void release() {
        this.nodeCursor.close();
        this.nodeCursor.release();
        this.relationshipTraversalCursor.close();
        this.relationshipTraversalCursor.release();
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.closeProgressor();
            this.read = null;
            this.txStateHolder = null;
            this.accessModeProvider = null;
            this.nodeCursor.close();
            this.relationshipTraversalCursor.close();
            this.relId = -1L;
            this.nodeFromIndex = -1L;
            this.readState = ReadState.UNAVAILABLE;
        }
        super.closeInternal();
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipTypeIndexCursor[closed state, node based]";
        }
        return String.format("RelationshipTypeIndexCursor[relationship=%s, state=%s, node based]", new Object[]{this.relationshipReference(), this.readState});
    }

    public RelationshipTypeIndexCursor getResource() {
        return this;
    }

    private static enum ReadState {
        TXSTATE_READ,
        INDEX_READ,
        NODE_READ,
        RELATIONSHIP_READ,
        UNAVAILABLE;

    }
}

