/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.impl.api.index.IndexingService;

public class SchemaAndIndexingFileIndexListing {
    private final IndexingService indexingService;

    SchemaAndIndexingFileIndexListing(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    Resource gatherSchemaIndexFiles(Collection<Path> targetFiles) throws IOException {
        ResourceIterator<Path> snapshot = this.indexingService.snapshotIndexFiles();
        SchemaAndIndexingFileIndexListing.getSnapshotFilesMetadata(snapshot, targetFiles);
        return snapshot;
    }

    private static void getSnapshotFilesMetadata(ResourceIterator<Path> snapshot, Collection<Path> targetFiles) {
        snapshot.stream().forEach(targetFiles::add);
    }
}

