/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.helpers.collection.Pair;

public class IndexSpecifier {
    private final String specification;
    private final String label;
    private final String property;

    public IndexSpecifier(String specification) {
        this.specification = specification;
        Pair<String, String> components = this.parse();
        this.label = (String)components.first();
        this.property = (String)components.other();
    }

    public String label() {
        return this.label;
    }

    public String property() {
        return this.property;
    }

    public String toString() {
        return this.specification;
    }

    private Pair<String, String> parse() {
        Pattern pattern = Pattern.compile(":" + IndexSpecifier.or(IndexSpecifier.simpleIdentifier("simpleLabel"), IndexSpecifier.complexIdentifier("complexLabel")) + "\\(" + IndexSpecifier.or(IndexSpecifier.simpleIdentifier("simpleProperty"), IndexSpecifier.complexIdentifier("complexProperty")) + "\\)");
        Matcher matcher = pattern.matcher(this.specification);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Cannot parse index specification " + this.specification);
        }
        return Pair.of((Object)this.either(matcher.group("simpleLabel"), matcher.group("complexLabel")), (Object)this.either(matcher.group("simpleProperty"), matcher.group("complexProperty")));
    }

    private String either(String first, String second) {
        return first != null ? first : second;
    }

    private static String or(String first, String second) {
        return "(:?" + first + "|" + second + ")";
    }

    private static String simpleIdentifier(String name) {
        return String.format("(?<%s>[A-Za-z0-9_]+)", name);
    }

    private static String complexIdentifier(String name) {
        return String.format("(?:`(?<%s>[^`]+)`)", name);
    }
}

