/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.neo4j.kernel.impl.store.kvstore.DeadState;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.KeyFormat;
import org.neo4j.kernel.impl.store.kvstore.ProgressiveState;
import org.neo4j.kernel.impl.store.kvstore.PrototypeState;
import org.neo4j.kernel.impl.store.kvstore.ReadableState;
import org.neo4j.kernel.impl.store.kvstore.RotationState;

public abstract class ActiveState<Key>
extends ProgressiveState<Key> {
    protected final ReadableState<Key> store;

    public ActiveState(ReadableState<Key> store) {
        this.store = store;
    }

    @Override
    protected final KeyFormat<Key> keyFormat() {
        return this.store.keyFormat();
    }

    @Override
    final String stateName() {
        return "active";
    }

    @Override
    protected abstract long storedVersion();

    @Override
    final RotationState.Rotation<Key> prepareRotation(long version) {
        version = Math.max(version, this.version());
        return new RotationState.Rotation<Key>(this, this.prototype(version), version);
    }

    @Override
    final Optional<EntryUpdater<Key>> optionalUpdater(long version, Lock lock) {
        return Optional.of(this.updater(version, lock));
    }

    protected abstract EntryUpdater<Key> updater(long var1, Lock var3);

    @Override
    final EntryUpdater<Key> resetter(Lock lock, Runnable closeAction) {
        if (this.hasChanges()) {
            throw new IllegalStateException("Cannot reset while there are changes.");
        }
        return this.resettingUpdater(lock, closeAction);
    }

    @Override
    final ProgressiveState<Key> stop() throws IOException {
        this.close();
        return new DeadState.Stopped<Key>(this.keyFormat(), this.factory());
    }

    @Override
    protected final Headers headers() {
        return this.store.headers();
    }

    @Override
    protected final int storedEntryCount() {
        return this.store.storedEntryCount();
    }

    protected abstract EntryUpdater<Key> resettingUpdater(Lock var1, Runnable var2);

    @Override
    protected abstract boolean hasChanges();

    protected abstract PrototypeState<Key> prototype(long var1);

    protected abstract Factory factory();

    protected abstract long applied();

    public static interface Factory {
        public <Key> ActiveState<Key> open(ReadableState<Key> var1, File var2);
    }
}

