/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ZonedTimeIndexKey;

class ZonedTimeLayout
extends IndexLayout<ZonedTimeIndexKey, NativeIndexValue> {
    ZonedTimeLayout() {
        super("Tzt", 0, 1);
    }

    public ZonedTimeIndexKey newKey() {
        return new ZonedTimeIndexKey();
    }

    public ZonedTimeIndexKey copyKey(ZonedTimeIndexKey key, ZonedTimeIndexKey into) {
        into.nanosOfDayUTC = key.nanosOfDayUTC;
        into.zoneOffsetSeconds = key.zoneOffsetSeconds;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    public int keySize(ZonedTimeIndexKey key) {
        return 20;
    }

    public void writeKey(PageCursor cursor, ZonedTimeIndexKey key) {
        cursor.putLong(key.nanosOfDayUTC);
        cursor.putInt(key.zoneOffsetSeconds);
        cursor.putLong(key.getEntityId());
    }

    public void readKey(PageCursor cursor, ZonedTimeIndexKey into, int keySize) {
        into.nanosOfDayUTC = cursor.getLong();
        into.zoneOffsetSeconds = cursor.getInt();
        into.setEntityId(cursor.getLong());
    }
}

