/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.storageengine.api.StorageReader;

public class KernelToken
implements Token {
    private final StorageReader store;
    private final KernelTransactionImplementation ktx;
    private final TokenHolders tokenHolders;

    public KernelToken(StorageReader store, KernelTransactionImplementation ktx, TokenHolders tokenHolders) {
        this.store = store;
        this.ktx = ktx;
        this.tokenHolders = tokenHolders;
    }

    public int labelGetOrCreateForName(String labelName) throws IllegalTokenNameException, TooManyLabelsException {
        try {
            return this.getOrCreateForName(this.tokenHolders.labelTokens(), labelName);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new TooManyLabelsException((Throwable)e);
            }
            throw e;
        }
    }

    public void labelGetOrCreateForNames(String[] labelNames, int[] labelIds) throws IllegalTokenNameException, TooManyLabelsException {
        try {
            this.getOrCreateForNames(this.tokenHolders.labelTokens(), labelNames, labelIds);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new TooManyLabelsException((Throwable)e);
            }
            throw e;
        }
    }

    public int labelCreateForName(String labelName) throws IllegalTokenNameException, TooManyLabelsException {
        this.ktx.assertOpen();
        int id = this.store.reserveLabelTokenId();
        this.ktx.txState().labelDoCreateForName(labelName, id);
        return id;
    }

    public int relationshipTypeCreateForName(String relationshipTypeName) throws IllegalTokenNameException {
        this.ktx.assertOpen();
        int id = this.store.reserveRelationshipTypeTokenId();
        this.ktx.txState().relationshipTypeDoCreateForName(relationshipTypeName, id);
        return id;
    }

    public int propertyKeyCreateForName(String propertyKeyName) throws IllegalTokenNameException {
        this.ktx.assertOpen();
        int id = this.store.reservePropertyKeyTokenId();
        this.ktx.txState().propertyKeyDoCreateForName(propertyKeyName, id);
        return id;
    }

    public int propertyKeyGetOrCreateForName(String propertyKeyName) throws IllegalTokenNameException {
        return this.getOrCreateForName(this.tokenHolders.propertyKeyTokens(), propertyKeyName);
    }

    public void propertyKeyGetOrCreateForNames(String[] propertyKeys, int[] ids) throws IllegalTokenNameException {
        this.getOrCreateForNames(this.tokenHolders.propertyKeyTokens(), propertyKeys, ids);
    }

    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) throws IllegalTokenNameException {
        return this.getOrCreateForName(this.tokenHolders.relationshipTypeTokens(), relationshipTypeName);
    }

    public void relationshipTypeGetOrCreateForNames(String[] relationshipTypes, int[] ids) throws IllegalTokenNameException {
        this.getOrCreateForNames(this.tokenHolders.relationshipTypeTokens(), relationshipTypes, ids);
    }

    public String nodeLabelName(int labelId) throws LabelNotFoundKernelException {
        this.ktx.assertOpen();
        try {
            return this.tokenHolders.labelTokens().getTokenById(labelId).name();
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException((long)labelId, (Exception)e);
        }
    }

    public int nodeLabel(String name) {
        this.ktx.assertOpen();
        return this.tokenHolders.labelTokens().getIdByName(name);
    }

    public int relationshipType(String name) {
        this.ktx.assertOpen();
        return this.tokenHolders.relationshipTypeTokens().getIdByName(name);
    }

    public String relationshipTypeName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        this.ktx.assertOpen();
        try {
            return this.tokenHolders.relationshipTypeTokens().getTokenById(relationshipTypeId).name();
        }
        catch (TokenNotFoundException e) {
            throw new RelationshipTypeIdNotFoundKernelException(relationshipTypeId, e);
        }
    }

    public int propertyKey(String name) {
        this.ktx.assertOpen();
        return this.tokenHolders.propertyKeyTokens().getIdByName(name);
    }

    public String propertyKeyName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        this.ktx.assertOpen();
        try {
            return this.tokenHolders.propertyKeyTokens().getTokenById(propertyKeyId).name();
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyIdNotFoundKernelException(propertyKeyId, (Exception)e);
        }
    }

    public Iterator<NamedToken> labelsGetAllTokens() {
        this.ktx.assertOpen();
        return this.tokenHolders.labelTokens().getAllTokens().iterator();
    }

    public Iterator<NamedToken> propertyKeyGetAllTokens() {
        this.ktx.assertOpen();
        AccessMode mode = this.ktx.securityContext().mode();
        return Iterators.stream(this.tokenHolders.propertyKeyTokens().getAllTokens().iterator()).filter(propKey -> mode.allowsPropertyReads(propKey.id())).iterator();
    }

    public Iterator<NamedToken> relationshipTypesGetAllTokens() {
        this.ktx.assertOpen();
        return this.tokenHolders.relationshipTypeTokens().getAllTokens().iterator();
    }

    public int labelCount() {
        this.ktx.assertOpen();
        return this.store.labelCount();
    }

    public int propertyKeyCount() {
        this.ktx.assertOpen();
        return this.store.propertyKeyCount();
    }

    public int relationshipTypeCount() {
        this.ktx.assertOpen();
        return this.store.relationshipTypeCount();
    }

    private String checkValidTokenName(String name) throws IllegalTokenNameException {
        if (name == null || name.isEmpty()) {
            throw new IllegalTokenNameException(name);
        }
        return name;
    }

    private int getOrCreateForName(TokenHolder tokens, String name) throws IllegalTokenNameException {
        this.ktx.assertOpen();
        int id = tokens.getIdByName(this.checkValidTokenName(name));
        if (id != -1) {
            return id;
        }
        this.ktx.assertAllows(AccessMode::allowsTokenCreates, "Token create");
        return tokens.getOrCreateId(name);
    }

    private void getOrCreateForNames(TokenHolder tokenHolder, String[] names, int[] ids) throws IllegalTokenNameException {
        this.ktx.assertOpen();
        this.assertSameLength(names, ids);
        for (int i = 0; i < names.length; ++i) {
            ids[i] = tokenHolder.getIdByName(this.checkValidTokenName(names[i]));
            if (ids[i] != -1) continue;
            this.ktx.assertAllows(AccessMode::allowsTokenCreates, "Token create");
            tokenHolder.getOrCreateIds(names, ids);
            return;
        }
    }

    private void assertSameLength(String[] names, int[] ids) {
        if (names.length != ids.length) {
            throw new IllegalArgumentException("Name and id arrays have different length.");
        }
    }
}

