/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class InternalTransactionCommitProcess
implements TransactionCommitProcess {
    private final TransactionAppender appender;
    private final StorageEngine storageEngine;
    private final DatabaseHealth health;

    public InternalTransactionCommitProcess(TransactionAppender appender, StorageEngine storageEngine, DatabaseHealth health) {
        this.appender = appender;
        this.storageEngine = storageEngine;
        this.health = health;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long commit(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        long lastTxId = this.appendToLog(batch, commitEvent);
        try {
            this.applyToStore(batch, commitEvent, mode);
            long l = lastTxId;
            return l;
        }
        finally {
            InternalTransactionCommitProcess.close(batch);
        }
    }

    private long appendToLog(TransactionToApply batch, CommitEvent commitEvent) throws TransactionFailureException {
        LogAppendEvent logAppendEvent = commitEvent.beginLogAppend();
        try {
            long l = this.appender.append(batch, logAppendEvent);
            if (logAppendEvent != null) {
                logAppendEvent.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (logAppendEvent != null) {
                    try {
                        logAppendEvent.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable cause) {
                TransactionFailureException exception = new TransactionFailureException((Status)Status.Transaction.TransactionLogError, cause, "Could not append transaction representation to log", new Object[0]);
                this.health.panic((Throwable)exception);
                throw exception;
            }
        }
    }

    protected void applyToStore(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        try (StoreApplyEvent storeApplyEvent = commitEvent.beginStoreApply();){
            this.storageEngine.apply((CommandsToApply)batch, mode);
        }
        catch (Throwable cause) {
            throw new TransactionFailureException((Status)Status.Transaction.TransactionCommitFailed, cause, "Could not apply the transaction to the store after written to log", new Object[0]);
        }
    }

    private static void close(TransactionToApply batch) {
        while (batch != null) {
            batch.publishAsClosed();
            batch.close();
            batch = batch.next();
        }
    }
}

