/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.Optional;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.reverse.DefaultTransactionCursors;
import org.neo4j.kernel.impl.transaction.log.reverse.PrefetchedTransactionCursors;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;
import org.neo4j.kernel.impl.transaction.log.reverse.TransactionCursors;

public class ReversedMultiFileTransactionCursor
implements TransactionCursor {
    private final TransactionCursors transactionCursors;
    private TransactionCursor currentLogTransactionCursor;

    public static TransactionCursor fromLogFile(LogFile logFile, LogPosition backToPosition, LogEntryReader logEntryReader, boolean failOnCorruptedLogFiles, ReversedTransactionCursorMonitor monitor, boolean presketch) {
        if (presketch) {
            return new ReversedMultiFileTransactionCursor(new PrefetchedTransactionCursors(logFile, backToPosition, logEntryReader, failOnCorruptedLogFiles, monitor));
        }
        return new ReversedMultiFileTransactionCursor(new DefaultTransactionCursors(logFile, backToPosition, logEntryReader, failOnCorruptedLogFiles, monitor));
    }

    public ReversedMultiFileTransactionCursor(TransactionCursors transactionCursors) {
        this.transactionCursors = transactionCursors;
    }

    public CommittedTransactionRepresentation get() {
        return (CommittedTransactionRepresentation)this.currentLogTransactionCursor.get();
    }

    public boolean next() throws IOException {
        while (this.currentLogTransactionCursor == null || !this.currentLogTransactionCursor.next()) {
            Optional<TransactionCursor> cursor = this.transactionCursors.next();
            if (cursor.isEmpty()) {
                return false;
            }
            this.closeCurrent();
            this.currentLogTransactionCursor = cursor.get();
        }
        return true;
    }

    public void close() throws IOException {
        this.closeCurrent();
        this.transactionCursors.close();
    }

    private void closeCurrent() throws IOException {
        if (this.currentLogTransactionCursor != null) {
            this.currentLogTransactionCursor.close();
            this.currentLogTransactionCursor = null;
        }
    }

    @Override
    public LogPosition position() {
        return this.currentLogTransactionCursor.position();
    }
}

