/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.monitoring.PageFileCounters;
import org.neo4j.io.pagecache.tracing.FileMappedListener;

public class DatabasePageCache
implements PageCache {
    private final PageCache globalPageCache;
    private final CopyOnWriteArrayList<PagedFile> databasePagedFiles = new CopyOnWriteArrayList();
    private final IOController ioController;
    private final List<FileMappedListener> mappedListeners = new CopyOnWriteArrayList<FileMappedListener>();
    private boolean closed;

    public DatabasePageCache(PageCache globalPageCache, IOController ioController) {
        this.globalPageCache = Objects.requireNonNull(globalPageCache);
        this.ioController = Objects.requireNonNull(ioController);
    }

    public PagedFile map(Path path, int pageSize, String databaseName, ImmutableSet<OpenOption> openOptions, IOController ignoredController) throws IOException {
        PagedFile pagedFile = this.globalPageCache.map(path, pageSize, databaseName, openOptions, this.ioController);
        DatabasePageFile databasePageFile = new DatabasePageFile(pagedFile, this.databasePagedFiles, this.mappedListeners);
        this.databasePagedFiles.add(databasePageFile);
        DatabasePageCache.invokeFileMapListeners(this.mappedListeners, databasePageFile);
        return databasePageFile;
    }

    public Optional<PagedFile> getExistingMapping(Path path) {
        Path canonicalFile = path.normalize();
        return this.databasePagedFiles.stream().filter(pagedFile -> pagedFile.path().equals(canonicalFile)).findFirst();
    }

    public List<PagedFile> listExistingMappings() {
        return new ArrayList<PagedFile>(this.databasePagedFiles);
    }

    public void flushAndForce() throws IOException {
        for (PagedFile pagedFile : this.databasePagedFiles) {
            pagedFile.flushAndForce();
        }
    }

    public synchronized void close() {
        if (this.closed) {
            throw new IllegalStateException("Database page cache was already closed");
        }
        for (PagedFile pagedFile : this.databasePagedFiles) {
            pagedFile.close();
        }
        this.databasePagedFiles.clear();
        this.closed = true;
    }

    public int pageSize() {
        return this.globalPageCache.pageSize();
    }

    public int pageReservedBytes() {
        return this.globalPageCache.pageReservedBytes();
    }

    public long maxCachedPages() {
        return this.globalPageCache.maxCachedPages();
    }

    public IOBufferFactory getBufferFactory() {
        return this.globalPageCache.getBufferFactory();
    }

    private static void invokeFileMapListeners(List<FileMappedListener> listeners, DatabasePageFile databasePageFile) {
        for (FileMappedListener mappedListener : listeners) {
            mappedListener.fileMapped((PagedFile)databasePageFile);
        }
    }

    private static void invokeFileUnmapListeners(List<FileMappedListener> listeners, DatabasePageFile databasePageFile) {
        for (FileMappedListener mappedListener : listeners) {
            mappedListener.fileUnmapped((PagedFile)databasePageFile);
        }
    }

    public void registerFileMappedListener(FileMappedListener mappedListener) {
        this.mappedListeners.add(mappedListener);
    }

    public void unregisterFileMappedListener(FileMappedListener mappedListener) {
        this.mappedListeners.remove(mappedListener);
    }

    private static class DatabasePageFile
    implements PagedFile {
        private final PagedFile delegate;
        private final List<PagedFile> databaseFiles;
        private final List<FileMappedListener> mappedListeners;

        DatabasePageFile(PagedFile delegate, List<PagedFile> databaseFiles, List<FileMappedListener> mappedListeners) {
            this.delegate = delegate;
            this.databaseFiles = databaseFiles;
            this.mappedListeners = mappedListeners;
        }

        public PageCursor io(long pageId, int pf_flags, CursorContext context) throws IOException {
            return this.delegate.io(pageId, pf_flags, context);
        }

        public int pageSize() {
            return this.delegate.pageSize();
        }

        public long fileSize() throws IOException {
            return this.delegate.fileSize();
        }

        public Path path() {
            return this.delegate.path();
        }

        public void flushAndForce() throws IOException {
            this.delegate.flushAndForce();
        }

        public long getLastPageId() throws IOException {
            return this.delegate.getLastPageId();
        }

        public void close() {
            DatabasePageCache.invokeFileUnmapListeners(this.mappedListeners, this);
            this.delegate.close();
            this.databaseFiles.remove(this);
        }

        public void setDeleteOnClose(boolean deleteOnClose) {
            this.delegate.setDeleteOnClose(deleteOnClose);
        }

        public boolean isDeleteOnClose() {
            return this.delegate.isDeleteOnClose();
        }

        public String getDatabaseName() {
            return this.delegate.getDatabaseName();
        }

        public PageFileCounters pageFileCounters() {
            return this.delegate.pageFileCounters();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabasePageFile that = (DatabasePageFile)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }
    }
}

