/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public final class SpatialIndexConfig {
    private SpatialIndexConfig() {
    }

    static void addSpatialConfig(Map<String, Value> map, CoordinateReferenceSystem crs, SpaceFillingCurveSettings settings) {
        double[] min = settings.indexExtents().getMin();
        double[] max = settings.indexExtents().getMax();
        SpatialIndexConfig.addSpatialConfig(map, crs, min, max);
    }

    public static void addSpatialConfig(Map<String, Value> map, CoordinateReferenceSystem crs, double[] min, double[] max) {
        String minKey = IndexSettingUtil.spatialMinSettingForCrs(crs).getSettingName();
        String maxKey = IndexSettingUtil.spatialMaxSettingForCrs(crs).getSettingName();
        map.put(minKey, (Value)Values.doubleArray((double[])min));
        map.put(maxKey, (Value)Values.doubleArray((double[])max));
    }

    static void validateSpatialConfig(IndexConfig indexConfig) {
        SpatialIndexConfig.extractSpatialConfig(indexConfig);
    }

    static IndexConfig addSpatialConfig(IndexConfig indexConfig, CoordinateReferenceSystem crs, SpaceFillingCurveSettings settings) {
        HashMap<String, Value> spatialConfig = new HashMap<String, Value>();
        SpatialIndexConfig.addSpatialConfig(spatialConfig, crs, settings);
        for (Map.Entry entry : spatialConfig.entrySet()) {
            indexConfig = indexConfig.withIfAbsent((String)entry.getKey(), (Value)entry.getValue());
        }
        return indexConfig;
    }

    static Map<CoordinateReferenceSystem, SpaceFillingCurveSettings> extractSpatialConfig(IndexConfig indexConfig) {
        HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> result = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();
        result.put(CoordinateReferenceSystem.Cartesian, SpatialIndexConfig.settingFromIndexConfig(indexConfig, CoordinateReferenceSystem.Cartesian));
        result.put(CoordinateReferenceSystem.Cartesian_3D, SpatialIndexConfig.settingFromIndexConfig(indexConfig, CoordinateReferenceSystem.Cartesian_3D));
        result.put(CoordinateReferenceSystem.WGS84, SpatialIndexConfig.settingFromIndexConfig(indexConfig, CoordinateReferenceSystem.WGS84));
        result.put(CoordinateReferenceSystem.WGS84_3D, SpatialIndexConfig.settingFromIndexConfig(indexConfig, CoordinateReferenceSystem.WGS84_3D));
        return result;
    }

    private static SpaceFillingCurveSettings settingFromIndexConfig(IndexConfig indexConfig, CoordinateReferenceSystem crs) {
        double[] min = SpatialIndexConfig.asDoubleArray(indexConfig.get(IndexSettingUtil.spatialMinSettingForCrs(crs).getSettingName()));
        double[] max = SpatialIndexConfig.asDoubleArray(indexConfig.get(IndexSettingUtil.spatialMaxSettingForCrs(crs).getSettingName()));
        Envelope envelope = new Envelope(min, max);
        return new SpaceFillingCurveSettings(crs.getDimension(), envelope);
    }

    private static double[] asDoubleArray(Value value) {
        if (value instanceof DoubleArray) {
            return ((DoubleArray)value).asObjectCopy();
        }
        throw new IllegalStateException(String.format("Expected value to be of type %s but was %s.", DoubleArray.class, value));
    }
}

