/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.util.Objects;
import org.neo4j.internal.helpers.collection.LruCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class TransactionMetadataCache {
    private static final int DEFAULT_TRANSACTION_CACHE_SIZE = 10000;
    private final LruCache<Long, TransactionMetadata> txIdMetadataCache = new LruCache("Tx start position cache", 10000);

    public void clear() {
        this.txIdMetadataCache.clear();
    }

    public TransactionMetadata getTransactionMetadata(long txId) {
        return (TransactionMetadata)this.txIdMetadataCache.get((Object)txId);
    }

    public void cacheTransactionMetadata(long txId, LogPosition position) {
        if (position.getByteOffset() == -1L) {
            throw new RuntimeException("StartEntry.position is " + String.valueOf(position));
        }
        TransactionMetadata result = new TransactionMetadata(position);
        this.txIdMetadataCache.put((Object)txId, (Object)result);
    }

    public static class TransactionMetadata {
        private final LogPosition startPosition;

        public TransactionMetadata(LogPosition startPosition) {
            this.startPosition = startPosition;
        }

        public LogPosition getStartPosition() {
            return this.startPosition;
        }

        public String toString() {
            return "TransactionMetadata{, startPosition=" + String.valueOf(this.startPosition) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionMetadata that = (TransactionMetadata)o;
            return Objects.equals(this.startPosition, that.startPosition);
        }

        public int hashCode() {
            return this.startPosition.hashCode();
        }
    }
}

