/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.BlockEntry;
import org.neo4j.kernel.impl.index.schema.BlockEntryCursor;

public class BlockEntryReader<KEY, VALUE>
implements BlockEntryCursor<KEY, VALUE> {
    private final long blockSize;
    private final long entryCount;
    private final PageCursor pageCursor;
    private final boolean produceNewKeyAndValueInstances;
    private final Layout<KEY, VALUE> layout;
    private KEY key;
    private VALUE value;
    private long readEntries;

    BlockEntryReader(PageCursor pageCursor, Layout<KEY, VALUE> layout, boolean produceNewKeyAndValueInstances) {
        this.pageCursor = pageCursor;
        this.blockSize = pageCursor.getLong();
        this.entryCount = pageCursor.getLong();
        this.layout = layout;
        this.key = produceNewKeyAndValueInstances ? null : layout.newKey();
        this.value = produceNewKeyAndValueInstances ? null : layout.newValue();
        this.produceNewKeyAndValueInstances = produceNewKeyAndValueInstances;
    }

    @Override
    public boolean next() throws IOException {
        if (this.readEntries >= this.entryCount) {
            return false;
        }
        if (this.produceNewKeyAndValueInstances) {
            this.key = this.layout.newKey();
            this.value = this.layout.newValue();
        }
        BlockEntry.read(this.pageCursor, this.layout, this.key, this.value);
        ++this.readEntries;
        return true;
    }

    public long blockSize() {
        return this.blockSize;
    }

    public long entryCount() {
        return this.entryCount;
    }

    @Override
    public KEY key() {
        return this.key;
    }

    @Override
    public VALUE value() {
        return this.value;
    }

    @Override
    public void close() throws IOException {
        this.pageCursor.close();
    }
}

