/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;

public final class LogHeaderWriter {
    static final long LOG_VERSION_BITS = 56L;
    static final long LOG_VERSION_MASK = 0xFFFFFFFFFFFFFFL;

    private LogHeaderWriter() {
    }

    public static void writeLogHeader(StoreChannel channel, LogHeader logHeader, MemoryTracker memoryTracker) throws IOException {
        if (logHeader.getLogFormatVersion() >= LogFormat.V9.getVersionByte()) {
            LogHeaderWriter.writeHeader9(channel, logHeader, memoryTracker);
        } else {
            LogHeaderWriter.writeHeader8(channel, logHeader, memoryTracker);
        }
        channel.flush();
    }

    private static void writeHeader8(StoreChannel channel, LogHeader logHeader, MemoryTracker memoryTracker) throws IOException {
        try (NativeScopedBuffer scopedBuffer = new NativeScopedBuffer(LogFormat.V8.getHeaderSize(), ByteOrder.BIG_ENDIAN, memoryTracker);){
            ByteBuffer buffer = scopedBuffer.getBuffer();
            LogHeaderWriter.putHeader(buffer, logHeader);
            buffer.flip();
            channel.writeAll(buffer);
        }
    }

    private static void writeHeader9(StoreChannel channel, LogHeader logHeader, MemoryTracker memoryTracker) throws IOException {
        try (NativeScopedBuffer scopedBuffer = new NativeScopedBuffer(logHeader.getSegmentBlockSize(), ByteOrder.BIG_ENDIAN, memoryTracker);){
            ByteBuffer buffer = scopedBuffer.getBuffer();
            LogHeaderWriter.putHeader(buffer, logHeader);
            buffer.position(logHeader.getSegmentBlockSize());
            buffer.flip();
            channel.writeAll(buffer);
        }
    }

    public static void putHeader(ByteBuffer buffer, LogHeader logHeader) throws IOException {
        ByteOrder originalOrder = buffer.order();
        try {
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putLong(LogHeaderWriter.encodeLogVersion(logHeader.getLogVersion(), logHeader.getLogFormatVersion()));
            buffer.putLong(logHeader.getLastCommittedTxId());
            StoreIdSerialization.serializeWithFixedSize((StoreId)logHeader.getStoreId(), (ByteBuffer)buffer);
            if (logHeader.getLogFormatVersion() >= LogFormat.V9.getVersionByte()) {
                buffer.putInt(logHeader.getSegmentBlockSize());
                buffer.putInt(logHeader.getPreviousLogFileChecksum());
            } else {
                buffer.putLong(0L);
            }
            buffer.putLong(0L);
            buffer.putLong(0L);
            buffer.putLong(0L);
            buffer.putLong(0L);
            buffer.putLong(0L);
        }
        finally {
            buffer.order(originalOrder);
        }
    }

    public static long encodeLogVersion(long logVersion, long formatVersion) {
        return logVersion & 0xFFFFFFFFFFFFFFL | formatVersion << 56;
    }
}

