/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeCursorBehaviour;
import org.neo4j.kernel.impl.transaction.state.storeview.PropertyAwareEntityStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockType;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class NodeStoreScan
extends PropertyAwareEntityStoreScan<StorageNodeCursor> {
    private static final String TRACER_TAG = "NodeStoreScan_getNodeCount";

    public NodeStoreScan(Config config, StorageReader storageReader, Function<CursorContext, StoreCursors> storeCursorsFactory, LockService locks, TokenScanConsumer labelScanConsumer, PropertyScanConsumer propertyScanConsumer, int[] labelIds, PropertySelection propertySelection, boolean parallelWrite, JobScheduler scheduler, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        super(config, storageReader, storeCursorsFactory, NodeStoreScan.getNodeCount(storageReader, contextFactory), labelIds, propertySelection, propertyScanConsumer, labelScanConsumer, id -> locks.acquireNodeLock(id, LockType.SHARED), new NodeCursorBehaviour(storageReader), parallelWrite, scheduler, contextFactory, memoryTracker, true);
    }

    static long getNodeCount(StorageReader storageReader, CursorContextFactory contextFactory) {
        try (CursorContext cursorContext = contextFactory.create(TRACER_TAG);){
            long l = storageReader.nodesGetCount(cursorContext);
            return l;
        }
    }
}

