/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.utils.TemporalValueWriterAdapter;

abstract class NativeIndexKey<SELF extends NativeIndexKey<SELF>>
extends TemporalValueWriterAdapter<RuntimeException> {
    public static final int ENTITY_ID_SIZE = 8;
    static final int NO_ENTITY_ID = -1;
    private static final boolean DEFAULT_COMPARE_ID = true;
    private long entityId;
    private boolean compareId = true;

    NativeIndexKey() {
    }

    void setCompareId(boolean compareId) {
        this.compareId = compareId;
    }

    boolean getCompareId() {
        return this.compareId;
    }

    long getEntityId() {
        return this.entityId;
    }

    void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    final void initFromValue(int stateSlot, Value value, Inclusion inclusion) {
        this.assertValidValue(stateSlot, value);
        this.writeValue(stateSlot, value, inclusion);
    }

    abstract void writeValue(int var1, Value var2, Inclusion var3);

    abstract void assertValidValue(int var1, Value var2);

    void initialize(long entityId) {
        this.compareId = true;
        this.setEntityId(entityId);
    }

    abstract Value[] asValues();

    abstract void initValueAsLowest(int var1, ValueGroup var2);

    abstract void initValueAsHighest(int var1, ValueGroup var2);

    abstract int numberOfStateSlots();

    final void initValuesAsLowest() {
        int slots = this.numberOfStateSlots();
        for (int i = 0; i < slots; ++i) {
            this.initValueAsLowest(i, ValueGroup.UNKNOWN);
        }
    }

    final void initValuesAsHighest() {
        int slots = this.numberOfStateSlots();
        for (int i = 0; i < slots; ++i) {
            this.initValueAsHighest(i, ValueGroup.UNKNOWN);
        }
    }

    abstract int compareValueTo(SELF var1);

    static enum Inclusion {
        LOW,
        NEUTRAL,
        HIGH;

    }
}

