/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.util.Optional;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogHeaderVisitor;

public final class TransactionLogVersionLocator
implements LogHeaderVisitor {
    private final long transactionId;
    private LogPosition foundPosition;

    public TransactionLogVersionLocator(long transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public boolean visit(LogHeader logHeader, LogPosition position, long firstTransactionIdInLog, long lastTransactionIdInLog) {
        boolean foundIt;
        boolean bl = foundIt = this.transactionId >= firstTransactionIdInLog && this.transactionId <= lastTransactionIdInLog;
        if (foundIt) {
            this.foundPosition = position;
        }
        return !foundIt;
    }

    public LogPosition getLogPositionOrThrow() throws NoSuchTransactionException {
        if (this.foundPosition == null) {
            throw new NoSuchTransactionException(this.transactionId, "Couldn't find any log containing " + this.transactionId);
        }
        return this.foundPosition;
    }

    public Optional<LogPosition> getOptionalLogPosition() {
        return Optional.ofNullable(this.foundPosition);
    }
}

