/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphDbmsModel;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.CappedLogger;

public class SystemGraphDatabaseIdRepository
implements DatabaseIdRepository {
    private final Supplier<Optional<? extends DatabaseContext>> systemDatabaseSupplier;
    private final CappedLogger cappedLogger;

    public SystemGraphDatabaseIdRepository(Supplier<Optional<? extends DatabaseContext>> systemDatabaseSupplier, InternalLogProvider logProvider) {
        this.systemDatabaseSupplier = systemDatabaseSupplier;
        this.cappedLogger = new CappedLogger(logProvider.getLog(this.getClass()), 10L, TimeUnit.SECONDS, Clock.systemUTC());
    }

    public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName normalizedDatabaseName) {
        return this.execute(model -> model.getDatabaseIdByAlias(normalizedDatabaseName.name()));
    }

    public Optional<NamedDatabaseId> getById(DatabaseId databaseId) {
        return this.execute(model -> model.getDatabaseIdByUUID(databaseId.uuid()));
    }

    private <T> Optional<T> execute(Function<TopologyGraphDbmsModel, Optional<T>> operation) {
        Optional<? extends DatabaseContext> databaseContext = this.systemDatabaseSupplier.get();
        if (databaseContext.isEmpty()) {
            this.cappedLogger.info("Could not retrieve the system database at this time.", new Object[0]);
            return Optional.empty();
        }
        GraphDatabaseAPI systemDb = databaseContext.get().databaseFacade();
        if (!systemDb.isAvailable(100L)) {
            this.cappedLogger.info("Currently, the system database is not available.", new Object[0]);
            return Optional.empty();
        }
        try (Transaction tx = systemDb.beginTx();){
            CommunityTopologyGraphDbmsModel model = new CommunityTopologyGraphDbmsModel(tx);
            Optional<T> optional = operation.apply(model);
            return optional;
        }
    }
}

