/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.nio.file.Files;
import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.NamedDiagnosticsProvider;
import org.neo4j.internal.helpers.Exceptions;

public class PackagingDiagnostics
extends NamedDiagnosticsProvider {
    public static final String PACKAGING_INFO_FILENAME = "packaging_info";
    private static final boolean PRINT_PACKAGING_INFO_ERROR = Boolean.getBoolean(PackagingDiagnostics.class.getName() + ".printException");
    private final Path home;

    PackagingDiagnostics(Config config) {
        super("Packaging");
        this.home = (Path)config.get(GraphDatabaseSettings.neo4j_home);
    }

    public void dump(DiagnosticsLogger logger) {
        block3: {
            Path packagingInfoPath = this.home.resolve(PACKAGING_INFO_FILENAME);
            try {
                for (String line : Files.readAllLines(packagingInfoPath)) {
                    if (line.startsWith("Version:")) continue;
                    logger.log(line);
                }
            }
            catch (Exception e) {
                logger.log("packaging_info is not available.");
                if (!PRINT_PACKAGING_INFO_ERROR) break block3;
                logger.log("Exception occurred while reading packaging_info file:" + Exceptions.stringify((Throwable)e));
            }
        }
    }
}

