/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.monitoring.Panic;

public class CheckpointerLifecycle
extends LifecycleAdapter {
    private final CheckPointer checkPointer;
    private final Panic databasePanic;
    private volatile boolean checkpointOnShutdown = true;

    public CheckpointerLifecycle(CheckPointer checkPointer, Panic databasePanic) {
        this.checkPointer = checkPointer;
        this.databasePanic = databasePanic;
    }

    public void setCheckpointOnShutdown(boolean checkpointOnShutdown) {
        this.checkpointOnShutdown = checkpointOnShutdown;
    }

    public void shutdown() throws Exception {
        if (this.checkpointOnShutdown && this.databasePanic.hasNoPanic()) {
            this.checkPointer.forceCheckPoint(new SimpleTriggerInfo("Database shutdown"));
        }
        this.checkPointer.shutdown();
    }
}

