/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint.volume;

import java.util.concurrent.TimeUnit;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;

public class VolumeCheckPointThreshold
extends AbstractCheckPointThreshold {
    private final long volumeBytes;
    private final long fileSizeBytes;
    private volatile LogPosition checkpointLogPosition;

    public VolumeCheckPointThreshold(long volumeBytes, long fileSizeBytes) {
        super("every " + ByteUnit.bytesToString((long)volumeBytes) + " of transaction logs.");
        this.volumeBytes = volumeBytes;
        this.fileSizeBytes = fileSizeBytes;
    }

    @Override
    protected boolean thresholdReached(long lastAppendIndex, LogPosition logPosition) {
        long offset;
        LogPosition previousLogPosition = this.checkpointLogPosition;
        long files = Math.abs(logPosition.getLogVersion() - previousLogPosition.getLogVersion());
        long bytesDiff = Math.abs(files * this.fileSizeBytes + (offset = logPosition.getByteOffset() - previousLogPosition.getByteOffset()));
        return this.volumeBytes < bytesDiff;
    }

    @Override
    public void initialize(long appendIndex, LogPosition logPosition) {
        this.checkpointLogPosition = logPosition;
    }

    @Override
    public void checkPointHappened(long appendIndex, LogPosition logPosition) {
        this.checkpointLogPosition = logPosition;
    }

    @Override
    public long checkFrequencyMillis() {
        return TimeUnit.SECONDS.toMillis(1L);
    }
}

