/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.util.Optional;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.UnclosableChannel;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v42.LogEntryDetachedCheckpointV4_2;
import org.neo4j.kernel.impl.transaction.log.entry.v50.LogEntryDetachedCheckpointV5_0;
import org.neo4j.kernel.impl.transaction.log.entry.v520.LogEntryDetachedCheckpointV5_20;
import org.neo4j.kernel.impl.transaction.log.entry.v522.LogEntryDetachedCheckpointV5_22;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public final class CheckpointInfoFactory {
    private static final long COMMIT_ENTRY_OFFSET = 22L;
    private static final long LEGACY_COMMIT_ENTRY_OFFSET = 18L;

    private CheckpointInfoFactory() {
    }

    public static CheckpointInfo ofLogEntry(LogEntry entry, LogPosition checkpointEntryPosition, LogPosition channelPositionAfterCheckpoint, LogPosition checkpointFilePostReadPosition, TransactionLogFilesContext context, LogFile logFile) {
        if (entry instanceof LogEntryDetachedCheckpointV5_22) {
            LogEntryDetachedCheckpointV5_22 checkpoint522 = (LogEntryDetachedCheckpointV5_22)entry;
            return new CheckpointInfo(checkpoint522.getOldestNotCompletedPosition(), checkpoint522.getCheckpointedLogPosition(), checkpoint522.getStoreId(), checkpointEntryPosition, channelPositionAfterCheckpoint, checkpointFilePostReadPosition, checkpoint522.kernelVersion(), checkpoint522.kernelVersion().version(), checkpoint522.getTransactionId(), checkpoint522.getLastAppendIndex(), checkpoint522.getReason(), checkpoint522.consensusIndexInCheckpoint());
        }
        if (entry instanceof LogEntryDetachedCheckpointV5_20) {
            LogEntryDetachedCheckpointV5_20 checkpoint520 = (LogEntryDetachedCheckpointV5_20)entry;
            return new CheckpointInfo(checkpoint520.getLogPosition(), checkpoint520.getLogPosition(), checkpoint520.getStoreId(), checkpointEntryPosition, channelPositionAfterCheckpoint, checkpointFilePostReadPosition, checkpoint520.kernelVersion(), checkpoint520.kernelVersion().version(), checkpoint520.getTransactionId(), checkpoint520.getLastAppendIndex(), checkpoint520.getReason(), checkpoint520.consensusIndexInCheckpoint());
        }
        if (entry instanceof LogEntryDetachedCheckpointV5_0) {
            LogEntryDetachedCheckpointV5_0 checkpoint50 = (LogEntryDetachedCheckpointV5_0)entry;
            return new CheckpointInfo(checkpoint50.getLogPosition(), checkpoint50.getLogPosition(), checkpoint50.getStoreId(), checkpointEntryPosition, channelPositionAfterCheckpoint, checkpointFilePostReadPosition, checkpoint50.kernelVersion(), checkpoint50.kernelVersion().version(), checkpoint50.getTransactionId(), checkpoint50.getTransactionId().id(), checkpoint50.getReason(), checkpoint50.consensusIndexInCheckpoint());
        }
        if (entry instanceof LogEntryDetachedCheckpointV4_2) {
            LogEntryDetachedCheckpointV4_2 checkpoint42 = (LogEntryDetachedCheckpointV4_2)entry;
            TransactionId transactionId = CheckpointInfoFactory.readTransactionInfoFor4_2(context, logFile, checkpoint42.getLogPosition());
            return new CheckpointInfo(checkpoint42.getLogPosition(), checkpoint42.getLogPosition(), checkpoint42.getStoreId(), checkpointEntryPosition, channelPositionAfterCheckpoint, checkpointFilePostReadPosition, transactionId.kernelVersion(), transactionId.kernelVersion().version(), transactionId, transactionId.id(), checkpoint42.getReason());
        }
        throw new UnsupportedOperationException("Expected to observe only checkpoint entries, but: `" + String.valueOf(entry) + "` was found.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TransactionId readTransactionInfoFor4_2(TransactionLogFilesContext context, LogFile logFile, LogPosition transactionPosition) {
        try (PhysicalLogVersionedStoreChannel channel = logFile.openForVersion(transactionPosition.getLogVersion());
             ReadAheadLogChannel reader = new ReadAheadLogChannel(new UnclosableChannel((LogVersionedStoreChannel)channel), context.getMemoryTracker());
             LogEntryCursor logEntryCursor = new LogEntryCursor((LogEntryReader)new VersionAwareLogEntryReader(context.getCommandReaderFactory(), context.getBinarySupportedKernelVersions()), (ReadableLogPositionAwareChannel)reader);){
            LogPosition checkedPosition = null;
            LogEntryStart logEntryStart = null;
            while (logEntryCursor.next()) {
                LogEntry logEntry = logEntryCursor.get();
                if (logEntry instanceof LogEntryStart) {
                    logEntryStart = (LogEntryStart)logEntry;
                }
                checkedPosition = reader.getCurrentLogPosition();
                if (!(logEntry instanceof LogEntryCommit)) continue;
                LogEntryCommit commit = (LogEntryCommit)logEntry;
                if (!checkedPosition.equals((Object)transactionPosition)) continue;
                if (logEntryStart == null) {
                    throw new IllegalStateException("Transaction commit entry for tx id: " + commit.getTxId() + " was found but transaction start was missing.");
                }
                TransactionId transactionId = new TransactionId(commit.getTxId(), commit.getTxId(), logEntryStart.kernelVersion(), commit.getChecksum(), commit.getTimeWritten(), -1L);
                return transactionId;
            }
            if ((Boolean)context.getConfig().get(GraphDatabaseInternalSettings.fail_on_corrupted_log_files) != false) throw new IllegalStateException("Checkpoint record pointed to " + String.valueOf(transactionPosition) + ", but log commit entry not found at that position. Last checked position: " + String.valueOf(checkedPosition));
            TransactionId transactionId = new TransactionId(TransactionIdStore.UNKNOWN_TRANSACTION_ID.id(), TransactionIdStore.UNKNOWN_TRANSACTION_ID.appendIndex(), KernelVersion.V4_4, TransactionIdStore.UNKNOWN_TRANSACTION_ID.checksum(), TransactionIdStore.UNKNOWN_TRANSACTION_ID.commitTimestamp(), TransactionIdStore.UNKNOWN_TRANSACTION_ID.consensusIndex());
            return transactionId;
        }
        catch (IllegalStateException e) {
            Throwable cause = e;
            try (PhysicalLogVersionedStoreChannel fallbackChannel = logFile.openForVersion(transactionPosition.getLogVersion());){
                fallbackChannel.position(transactionPosition.getByteOffset() - 22L);
                Optional<TransactionId> transactionInfo44 = CheckpointInfoFactory.tryReadTransactionInfo(fallbackChannel, context, false);
                if (transactionInfo44.isPresent()) {
                    TransactionId logEntryStart = transactionInfo44.get();
                    return logEntryStart;
                }
                fallbackChannel.position(transactionPosition.getByteOffset() - 18L);
                Optional<TransactionId> transactionInfo42 = CheckpointInfoFactory.tryReadTransactionInfo(fallbackChannel, context, true);
                if (!transactionInfo42.isPresent()) throw new RuntimeException("Unable to find last transaction in log files. Position: " + String.valueOf(transactionPosition), cause);
                TransactionId transactionId = transactionInfo42.get();
                return transactionId;
            }
            catch (Exception fe) {
                cause = Exceptions.chain((Throwable)cause, (Throwable)fe);
            }
            throw new RuntimeException("Unable to find last transaction in log files. Position: " + String.valueOf(transactionPosition), cause);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to find last transaction in log files. Position: " + String.valueOf(transactionPosition), t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<TransactionId> tryReadTransactionInfo(PhysicalLogVersionedStoreChannel fallbackChannel, TransactionLogFilesContext context, boolean skipChecksum) {
        if (fallbackChannel.getLogFormatVersion().usesSegments()) {
            return Optional.empty();
        }
        try (ReadAheadLogChannel fallbackReader = new ReadAheadLogChannel(new UnclosableChannel((LogVersionedStoreChannel)fallbackChannel), context.getMemoryTracker());){
            byte versionCode = fallbackReader.get();
            if (context.getBinarySupportedKernelVersions().latestSupportedIsLessThan(versionCode)) {
                Optional<TransactionId> optional = Optional.empty();
                return optional;
            }
            KernelVersion kernelVersion = KernelVersion.EARLIEST.isGreaterThan(versionCode) ? KernelVersion.EARLIEST : KernelVersion.getForVersion((byte)versionCode);
            boolean reverseBytes = kernelVersion.isLessThan(KernelVersion.VERSION_LITTLE_ENDIAN_TX_LOG_INTRODUCED);
            byte entryCode = fallbackReader.get();
            if (entryCode != 5) {
                Optional<TransactionId> optional = Optional.empty();
                return optional;
            }
            long transactionId = CheckpointInfoFactory.maybeReverse(fallbackReader.getLong(), reverseBytes);
            long timeWritten = CheckpointInfoFactory.maybeReverse(fallbackReader.getLong(), reverseBytes);
            int checksum = skipChecksum ? 0 : CheckpointInfoFactory.maybeReverse(fallbackReader.getInt(), reverseBytes);
            Optional<TransactionId> optional = Optional.of(new TransactionId(transactionId, transactionId, kernelVersion, checksum, timeWritten, -1L));
            return optional;
        }
        catch (Exception e) {
            context.getLogProvider().getLog(CheckpointInfoFactory.class).debug("Fail to extract legacy transaction info.", (Throwable)e);
            return Optional.empty();
        }
    }

    private static int maybeReverse(int value, boolean reverseBytes) {
        return reverseBytes ? Integer.reverseBytes(value) : value;
    }

    private static long maybeReverse(long value, boolean reverseBytes) {
        return reverseBytes ? Long.reverseBytes(value) : value;
    }
}

