/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.lock;

import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.lock.ResourceType;

public enum ResourceTypes implements ResourceType
{
    NODE(0),
    RELATIONSHIP(1),
    INDEX_ENTRY(2),
    LABEL(3),
    RELATIONSHIP_TYPE(4),
    SCHEMA_NAME(5),
    RELATIONSHIP_DELETE(6),
    NODE_RELATIONSHIP_GROUP_DELETE(7),
    DEGREES(8),
    RELATIONSHIP_GROUP(9);

    private static final MutableIntObjectMap<ResourceType> idToType;
    private final int typeId;

    private ResourceTypes(int typeId) {
        this.typeId = typeId;
    }

    @Override
    public int typeId() {
        return this.typeId;
    }

    public static ResourceType fromId(int typeId) {
        return (ResourceType)idToType.get(typeId);
    }

    static {
        idToType = new IntObjectHashMap();
        for (ResourceTypes resourceTypes : ResourceTypes.values()) {
            idToType.put(resourceTypes.typeId, (Object)resourceTypes);
        }
    }
}

