/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public abstract class AbstractLogProvider<T extends Log>
implements LogProvider {
    private final ConcurrentHashMap<String, T> logCache = new ConcurrentHashMap();

    public T getLog(Class loggingClass) {
        return (T)this.getLog(loggingClass.getName(), () -> this.buildLog(loggingClass));
    }

    public T getLog(String name) {
        return (T)this.getLog(name, () -> this.buildLog(name));
    }

    private T getLog(String name, Supplier<T> logSupplier) {
        return (T)this.logCache.computeIfAbsent(name, s -> (Log)logSupplier.get());
    }

    protected Collection<T> cachedLogs() {
        return this.logCache.values();
    }

    protected abstract T buildLog(Class var1);

    protected abstract T buildLog(String var1);
}

