/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.neo4j.function.Suppliers;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.FormattedLogger;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;
import org.neo4j.logging.NullLogger;

public class FormattedLog
extends AbstractLog {
    static final Function<OutputStream, PrintWriter> OUTPUT_STREAM_CONVERTER = outputStream -> new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));
    private final Supplier<PrintWriter> writerSupplier;
    final ZoneId zoneId;
    final Object lock;
    private final String category;
    private final AtomicReference<Level> levelRef;
    final boolean autoFlush;
    private final Logger debugLogger;
    private final Logger infoLogger;
    private final Logger warnLogger;
    private final Logger errorLogger;

    public static Builder withUTCTimeZone() {
        return new Builder().withUTCZoneId();
    }

    @Deprecated
    public static Builder withTimeZone(TimeZone timezone) {
        return new Builder().withZoneId(timezone.toZoneId());
    }

    public static Builder withZoneId(ZoneId zoneId) {
        return new Builder().withZoneId(zoneId);
    }

    public static Builder usingLock(Object lock) {
        return new Builder().usingLock(lock);
    }

    public static Builder withCategory(String category) {
        return new Builder().withCategory(category);
    }

    public static Builder withLogLevel(Level level) {
        return new Builder().withLogLevel(level);
    }

    public static Builder withoutAutoFlush() {
        return new Builder().withoutAutoFlush();
    }

    public static FormattedLog toOutputStream(OutputStream out) {
        return new Builder().toOutputStream(out);
    }

    public static FormattedLog toOutputStream(Supplier<OutputStream> outSupplier) {
        return new Builder().toOutputStream(outSupplier);
    }

    public static FormattedLog toWriter(Writer writer) {
        return new Builder().toWriter(writer);
    }

    public static FormattedLog toPrintWriter(PrintWriter writer) {
        return new Builder().toPrintWriter(writer);
    }

    public static FormattedLog toPrintWriter(Supplier<PrintWriter> writerSupplier) {
        return new Builder().toPrintWriter(writerSupplier);
    }

    protected FormattedLog(Supplier<PrintWriter> writerSupplier, ZoneId zoneId, Object maybeLock, String category, Level level, boolean autoFlush) {
        this(writerSupplier, zoneId, maybeLock, category, level, autoFlush, FormattedLogger.DATE_TIME_FORMATTER, () -> FormattedLogger.DEFAULT_CURRENT_DATE_TIME.apply(zoneId));
    }

    protected FormattedLog(Supplier<PrintWriter> writerSupplier, ZoneId zoneId, Object maybeLock, String category, Level level, boolean autoFlush, DateTimeFormatter dateTimeFormatter, Supplier<ZonedDateTime> dateTimeSupplier) {
        this.writerSupplier = writerSupplier;
        this.zoneId = zoneId;
        this.lock = maybeLock != null ? maybeLock : this;
        this.category = category;
        this.levelRef = new AtomicReference<Level>(level);
        this.autoFlush = autoFlush;
        String debugPrefix = category != null && !category.isEmpty() ? "DEBUG [" + category + "]" : "DEBUG";
        String infoPrefix = category != null && !category.isEmpty() ? "INFO [" + category + "]" : "INFO ";
        String warnPrefix = category != null && !category.isEmpty() ? "WARN [" + category + "]" : "WARN ";
        String errorPrefix = category != null && !category.isEmpty() ? "ERROR [" + category + "]" : "ERROR";
        this.debugLogger = new FormattedLogger(this, writerSupplier, debugPrefix, dateTimeFormatter, dateTimeSupplier);
        this.infoLogger = new FormattedLogger(this, writerSupplier, infoPrefix, dateTimeFormatter, dateTimeSupplier);
        this.warnLogger = new FormattedLogger(this, writerSupplier, warnPrefix, dateTimeFormatter, dateTimeSupplier);
        this.errorLogger = new FormattedLogger(this, writerSupplier, errorPrefix, dateTimeFormatter, dateTimeSupplier);
    }

    public Level getLevel() {
        return this.levelRef.get();
    }

    public Level setLevel(Level level) {
        return this.levelRef.getAndSet(level);
    }

    @Override
    public boolean isDebugEnabled() {
        return Level.DEBUG.compareTo((Enum)this.levelRef.get()) >= 0;
    }

    @Override
    @Nonnull
    public Logger debugLogger() {
        return this.isDebugEnabled() ? this.debugLogger : NullLogger.getInstance();
    }

    public boolean isInfoEnabled() {
        return Level.INFO.compareTo((Enum)this.levelRef.get()) >= 0;
    }

    @Override
    @Nonnull
    public Logger infoLogger() {
        return this.isInfoEnabled() ? this.infoLogger : NullLogger.getInstance();
    }

    public boolean isWarnEnabled() {
        return Level.WARN.compareTo((Enum)this.levelRef.get()) >= 0;
    }

    @Override
    @Nonnull
    public Logger warnLogger() {
        return this.isWarnEnabled() ? this.warnLogger : NullLogger.getInstance();
    }

    public boolean isErrorEnabled() {
        return Level.ERROR.compareTo((Enum)this.levelRef.get()) >= 0;
    }

    @Override
    @Nonnull
    public Logger errorLogger() {
        return this.isErrorEnabled() ? this.errorLogger : NullLogger.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulk(@Nonnull Consumer<Log> consumer) {
        PrintWriter writer;
        Object object = this.lock;
        synchronized (object) {
            writer = this.writerSupplier.get();
            consumer.accept(new FormattedLog(Suppliers.singleton((Object)writer), this.zoneId, this.lock, this.category, this.levelRef.get(), false));
        }
        if (this.autoFlush) {
            writer.flush();
        }
    }

    public static class Builder {
        private ZoneId zoneId = ZoneOffset.UTC;
        private Object lock = this;
        private String category;
        private Level level = Level.INFO;
        private boolean autoFlush = true;
        private DateTimeFormatter dateTimeFormatter = FormattedLogger.DATE_TIME_FORMATTER;
        private Supplier<ZonedDateTime> dateTimeFormatterSupplier = () -> FormattedLogger.DEFAULT_CURRENT_DATE_TIME.apply(this.zoneId);

        private Builder() {
        }

        public Builder withUTCZoneId() {
            return this.withZoneId(ZoneOffset.UTC);
        }

        @Deprecated
        public Builder withTimeZone(TimeZone timezone) {
            return this.withZoneId(timezone.toZoneId());
        }

        public Builder withZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder withDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
            return this;
        }

        public Builder usingLock(Object lock) {
            this.lock = lock;
            return this;
        }

        public Builder withCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder withLogLevel(Level level) {
            this.level = level;
            return this;
        }

        Builder withTimeSupplier(Supplier<ZonedDateTime> zonedDateTimeSupplier) {
            this.dateTimeFormatterSupplier = zonedDateTimeSupplier;
            return this;
        }

        public Builder withoutAutoFlush() {
            this.autoFlush = false;
            return this;
        }

        public FormattedLog toOutputStream(OutputStream out) {
            return this.toPrintWriter(Suppliers.singleton((Object)OUTPUT_STREAM_CONVERTER.apply(out)));
        }

        public FormattedLog toOutputStream(Supplier<OutputStream> outSupplier) {
            return this.toPrintWriter(Suppliers.adapted(outSupplier, OUTPUT_STREAM_CONVERTER));
        }

        public FormattedLog toWriter(Writer writer) {
            return this.toPrintWriter(new PrintWriter(writer));
        }

        public FormattedLog toPrintWriter(PrintWriter writer) {
            return this.toPrintWriter(Suppliers.singleton((Object)writer));
        }

        public FormattedLog toPrintWriter(Supplier<PrintWriter> writerSupplier) {
            return new FormattedLog(writerSupplier, this.zoneId, this.lock, this.category, this.level, this.autoFlush, this.dateTimeFormatter, this.dateTimeFormatterSupplier);
        }
    }
}

