/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongPredicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.common.Subject;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.LuceneIndexConsistencyCheckVisitor;
import org.neo4j.kernel.api.impl.index.LucenePartitionsAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.schema.LuceneIndexReaderAcquisitionException;
import org.neo4j.kernel.api.impl.schema.reader.LuceneAllEntriesIndexAccessorReader;
import org.neo4j.kernel.api.impl.schema.writer.LucenePartitionIndexWriter;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.api.index.IndexEntryConflictHandler;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobHandles;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class AbstractLuceneIndexAccessor<READER extends ValueIndexReader, INDEX extends DatabaseIndex<READER>>
implements IndexAccessor {
    protected final LucenePartitionIndexWriter writer;
    protected final INDEX luceneIndex;
    protected final IndexDescriptor descriptor;
    private final IndexUpdateIgnoreStrategy ignoreStrategy;

    protected AbstractLuceneIndexAccessor(INDEX luceneIndex, IndexDescriptor descriptor, IndexUpdateIgnoreStrategy ignoreStrategy) {
        this.writer = luceneIndex.isPermanentlyOnly() ? null : luceneIndex.getIndexWriter();
        this.luceneIndex = luceneIndex;
        this.descriptor = descriptor;
        this.ignoreStrategy = ignoreStrategy;
    }

    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
        if (this.luceneIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create index updater while database is in read only mode.");
        }
        return this.getIndexUpdater(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertFrom(IndexAccessor other, LongToLongFunction entityIdConverter, boolean valueUniqueness, IndexEntryConflictHandler conflictHandler, LongPredicate entityFilter, int threads, JobScheduler jobScheduler, ProgressListener progress) {
        AbstractLuceneIndexAccessor o = (AbstractLuceneIndexAccessor)other;
        try {
            o.luceneIndex.accessClosedDirectories((ThrowingBiConsumer<Integer, LuceneDirectory, IOException>)((ThrowingBiConsumer)this.writer::addDirectory));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.refresh();
        if (entityFilter != null) {
            IndexEntriesReader[] partitions = this.newAllEntriesValueReader(threads, CursorContext.NULL_CONTEXT);
            try {
                ArrayList<JobHandle> handles = new ArrayList<JobHandle>();
                for (IndexEntriesReader partition : partitions) {
                    handles.add(jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(Subject.AUTH_DISABLED, "db", "insertFrom"), () -> {
                        try (IndexUpdater updater = this.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL_CONTEXT, false);){
                            while (partition.hasNext()) {
                                long candidate = partition.next();
                                if (entityFilter.test(candidate)) continue;
                                Value[] values = new Value[this.descriptor.schema().getPropertyIds().length];
                                for (int i = 0; i < values.length; ++i) {
                                    values[i] = Values.stringValue((String)"");
                                }
                                updater.process((IndexEntryUpdate)ValueIndexEntryUpdate.remove((long)candidate, (IndexDescriptor)this.descriptor, (Value[])values));
                                progress.add(1L);
                            }
                        }
                        return null;
                    }));
                    JobHandles.getAllResults(handles, RuntimeException.class, RuntimeException::new);
                }
            }
            finally {
                IOUtils.closeAllUnchecked((AutoCloseable[])partitions);
            }
        }
    }

    public void validate(IndexAccessor other, boolean valueUniqueness, IndexEntryConflictHandler conflictHandler, int threads, JobScheduler jobScheduler) {
        throw new UnsupportedOperationException();
    }

    protected abstract IndexUpdater getIndexUpdater(IndexUpdateMode var1);

    public void drop() {
        if (this.luceneIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't drop index while database is in read only mode.");
        }
        this.luceneIndex.drop();
    }

    public void force(FileFlushEvent flushEvent, CursorContext cursorContext) {
        try {
            if (!this.luceneIndex.isReadOnly()) {
                this.luceneIndex.markAsOnline();
            }
            this.luceneIndex.maybeRefreshBlocking();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void refresh() {
        try {
            this.luceneIndex.maybeRefreshBlocking();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void close() {
        try {
            this.luceneIndex.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public READER newValueReader(IndexUsageTracking usageTracker) {
        try {
            return this.luceneIndex.getIndexReader(usageTracker);
        }
        catch (IOException e) {
            throw new LuceneIndexReaderAcquisitionException("Can't acquire index reader", e);
        }
    }

    protected BoundedIterable<Long> newAllEntriesReader(ToLongFunction<LuceneDocument> entityIdReader, long fromIdInclusive, long toIdExclusive) {
        return new LuceneAllEntriesIndexAccessorReader(this.luceneIndex.allDocumentsReader(), entityIdReader, fromIdInclusive, toIdExclusive);
    }

    public IndexEntriesReader[] newAllEntriesValueReader(ToLongFunction<LuceneDocument> entityIdReader, int numPartitions) {
        LucenePartitionsAllDocumentsReader allDocumentsReader = this.luceneIndex.allDocumentsReader();
        List<Iterator<LuceneDocument>> partitions = allDocumentsReader.partition(numPartitions);
        AtomicInteger closeCount = new AtomicInteger(partitions.size());
        List readers = partitions.stream().map(partitionDocuments -> new PartitionIndexEntriesReader(closeCount, allDocumentsReader, entityIdReader, (Iterator<LuceneDocument>)partitionDocuments)).collect(Collectors.toList());
        return (IndexEntriesReader[])readers.toArray(IndexEntriesReader[]::new);
    }

    public ResourceIterator<Path> snapshotFiles() throws IOException {
        return this.luceneIndex.snapshotFiles();
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads, ProgressMonitorFactory progressMonitorFactory) {
        LuceneIndexConsistencyCheckVisitor visitor = (LuceneIndexConsistencyCheckVisitor)reporterFactory.getClass(LuceneIndexConsistencyCheckVisitor.class);
        boolean isConsistent = this.luceneIndex.isValid();
        if (!isConsistent) {
            visitor.isInconsistent(this.descriptor);
        }
        return isConsistent;
    }

    public long estimateNumberOfEntries(CursorContext ignored) {
        long l;
        block8: {
            LucenePartitionsAllDocumentsReader documentsReader = this.luceneIndex.allDocumentsReader();
            try {
                l = documentsReader.maxCount();
                if (documentsReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (documentsReader != null) {
                        try {
                            documentsReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            documentsReader.close();
        }
        return l;
    }

    public long sizeInBytes() {
        return this.luceneIndex.sizeInBytes();
    }

    private static class PartitionIndexEntriesReader
    implements IndexEntriesReader {
        private final AtomicInteger closeCount;
        private final LucenePartitionsAllDocumentsReader allDocumentsReader;
        private final ToLongFunction<LuceneDocument> entityIdReader;
        private final Iterator<LuceneDocument> partitionDocuments;

        PartitionIndexEntriesReader(AtomicInteger closeCount, LucenePartitionsAllDocumentsReader allDocumentsReader, ToLongFunction<LuceneDocument> entityIdReader, Iterator<LuceneDocument> partitionDocuments) {
            this.closeCount = closeCount;
            this.allDocumentsReader = allDocumentsReader;
            this.entityIdReader = entityIdReader;
            this.partitionDocuments = partitionDocuments;
        }

        public Value[] values() {
            return null;
        }

        public void close() {
            if (this.closeCount.decrementAndGet() == 0) {
                try {
                    this.allDocumentsReader.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        public long next() {
            return this.entityIdReader.applyAsLong(this.partitionDocuments.next());
        }

        public boolean hasNext() {
            return this.partitionDocuments.hasNext();
        }
    }

    protected abstract class AbstractLuceneIndexUpdater
    implements IndexUpdater {
        private final boolean idempotent;
        private final Runnable refreshAction;
        private boolean hasChanges;

        protected AbstractLuceneIndexUpdater(boolean idempotent, boolean refresh) {
            this(idempotent, refresh ? this$0::refresh : () -> {});
        }

        protected AbstractLuceneIndexUpdater(boolean idempotent, Runnable refreshAction) {
            this.idempotent = idempotent;
            this.refreshAction = refreshAction;
        }

        public void close() {
            if (this.hasChanges) {
                this.refreshAction.run();
            }
        }

        public void process(IndexEntryUpdate update) {
            assert (update.indexKey().schema().equals((Object)AbstractLuceneIndexAccessor.this.descriptor.schema()));
            ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
            if (valueUpdate == null) {
                return;
            }
            long entityId = valueUpdate.getEntityId();
            Value[] values = valueUpdate.values();
            UpdateMode updateMode = valueUpdate.updateMode();
            switch (updateMode) {
                case ADDED: {
                    if (this.idempotent) {
                        this.addIdempotent(entityId, values);
                        break;
                    }
                    this.add(entityId, values);
                    break;
                }
                case CHANGED: {
                    this.change(entityId, values);
                    break;
                }
                case REMOVED: {
                    this.remove(entityId);
                }
            }
            this.hasChanges = true;
        }

        public ValueIndexEntryUpdate asValueUpdate(IndexEntryUpdate update) {
            ValueIndexEntryUpdate valueUpdate = super.asValueUpdate(update);
            return !AbstractLuceneIndexAccessor.this.ignoreStrategy.ignore(valueUpdate) ? AbstractLuceneIndexAccessor.this.ignoreStrategy.toEquivalentUpdate(valueUpdate) : null;
        }

        protected abstract void addIdempotent(long var1, Value[] var3);

        protected abstract void add(long var1, Value[] var3);

        protected abstract void change(long var1, Value[] var3);

        protected abstract void remove(long var1);
    }
}

