/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigMode;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriterConfig;
import org.neo4j.kernel.api.impl.index.lucene.LuceneSettings;

public final class IndexWriterConfigBuilder {
    private static final Analyzer KEYWORD_ANALYZER = new KeywordAnalyzer();
    private final IndexWriterConfigMode mode;
    private final Config config;
    private Analyzer analyzer = KEYWORD_ANALYZER;
    private Codec codec;

    public IndexWriterConfigBuilder(IndexWriterConfigMode mode, Config config) {
        this.mode = mode;
        this.config = config;
    }

    public IndexWriterConfigBuilder withAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public IndexWriterConfigBuilder withCodec(Codec codec) {
        this.codec = codec;
        return this;
    }

    public LuceneIndexWriterConfig build() {
        LuceneIndexWriterConfig writerConfig = new LuceneIndexWriterConfig(this.analyzer);
        if (this.codec != null) {
            writerConfig.setCodec(this.codec);
        }
        writerConfig.setMergingParameters((Double)this.config.get(LuceneSettings.lucene_nocfs_ratio), (Double)this.config.get(LuceneSettings.lucene_min_merge), (Double)this.config.get(LuceneSettings.lucene_max_merge), this.mode.getMergeFactor(this.config));
        return this.mode.visitWithConfig(writerConfig, this.config);
    }
}

