/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;

public class LuceneIndexWriterConfig {
    public static final int DISABLE_AUTO_FLUSH = -1;
    public static final double DEFAULT_RAM_BUFFER_SIZE_MB = 16.0;
    public final boolean analyzerOnly;
    public final Analyzer analyzer;
    public boolean useOnThreadConcurrentMergeScheduler;
    public Integer maxBufferedDocs;
    public Double RAMBufferSizeMB;
    public boolean commitOnClose = true;
    public Codec codec;
    public double noCFSRatio;
    public double minMergeMB;
    public double maxMergeMB;
    public int mergeFactor;

    public static LuceneIndexWriterConfig analyzerOnly(Analyzer analyzer) {
        return new LuceneIndexWriterConfig(analyzer, true);
    }

    public LuceneIndexWriterConfig(Analyzer analyzer) {
        this(analyzer, false);
    }

    private LuceneIndexWriterConfig(Analyzer analyzer, boolean analyzerOnly) {
        this.analyzer = analyzer;
        this.analyzerOnly = analyzerOnly;
    }

    public LuceneIndexWriterConfig setRAMBufferSizeMB(double RAMBufferSizeMB) {
        this.RAMBufferSizeMB = RAMBufferSizeMB;
        return this;
    }

    public LuceneIndexWriterConfig setMaxBufferedDocs(int maxBufferedDocs) {
        this.maxBufferedDocs = maxBufferedDocs;
        return this;
    }

    public LuceneIndexWriterConfig useOnThreadConcurrentMergeScheduler() {
        this.useOnThreadConcurrentMergeScheduler = true;
        return this;
    }

    public LuceneIndexWriterConfig setCommitOnClose(boolean commitOnClose) {
        this.commitOnClose = commitOnClose;
        return this;
    }

    public LuceneIndexWriterConfig setCodec(Codec codec) {
        this.codec = codec;
        return this;
    }

    public void setMergingParameters(double noCFSRatio, double minMergeMB, double maxMergeMB, int mergeFactor) {
        this.noCFSRatio = noCFSRatio;
        this.minMergeMB = minMergeMB;
        this.maxMergeMB = maxMergeMB;
        this.mergeFactor = mergeFactor;
    }
}

