/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.LongPredicate;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.kernel.api.impl.index.collector.ScoredEntityIterator;
import org.neo4j.kernel.api.impl.index.collector.ScoredEntityResultCollector;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.LucenePartitionedSearch;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryContext;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9IndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9Neo4jIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9QueryContext;

class Lucene9PartitionedSearch
implements LucenePartitionedSearch {
    private final List<PreparedSearch> searches;

    Lucene9PartitionedSearch(int size) {
        this.searches = new ArrayList<PreparedSearch>(size);
    }

    @Override
    public void addPartitionSearcher(LuceneIndexSearcher indexSearcher, LongPredicate filter) {
        this.searches.add(new PreparedSearch(((Lucene9IndexSearcher)indexSearcher).indexSearcher, filter));
    }

    @Override
    public ValuesIterator search(LuceneQueryContext queryContext, IndexQueryConstraints constraints) throws IOException {
        StatsCollector statsCollector = new StatsCollector(this.searches);
        ArrayList<ValuesIterator> results = new ArrayList<ValuesIterator>(this.searches.size());
        for (PreparedSearch preparedSearch : this.searches) {
            FulltextResultCollector collector = new FulltextResultCollector(constraints, preparedSearch.filter);
            StatsCachingIndexSearcher statsCachingIndexSearcher = new StatsCachingIndexSearcher(preparedSearch.indexSearcher, statsCollector);
            Weight weight = statsCachingIndexSearcher.createWeight(((Lucene9QueryContext)queryContext).build(), collector.scoreMode(), 1.0f);
            ((Lucene9Neo4jIndexSearcher)preparedSearch.indexSearcher).search(weight, collector);
            results.add(collector.iterator());
        }
        return ScoredEntityIterator.mergeIterators(results);
    }

    private record PreparedSearch(IndexSearcher indexSearcher, LongPredicate filter) {
    }

    private static class StatsCollector {
        private final List<PreparedSearch> searches;
        private final Map<Term, Optional<TermStatistics>> termStatisticsCache;
        private final Map<String, Optional<CollectionStatistics>> collStatisticsCache;

        StatsCollector(List<PreparedSearch> searches) {
            this.searches = searches;
            this.termStatisticsCache = new HashMap<Term, Optional<TermStatistics>>();
            this.collStatisticsCache = new HashMap<String, Optional<CollectionStatistics>>();
        }

        TermStatistics termStatistics(Term term) {
            return this.termStatisticsCache.computeIfAbsent(term, this::computeTermStatistics).orElse(null);
        }

        private Optional<TermStatistics> computeTermStatistics(Term term) {
            ArrayList<TermStatistics> statistics = new ArrayList<TermStatistics>(this.searches.size());
            for (PreparedSearch preparedSearch : this.searches) {
                IndexSearcher searcher = preparedSearch.indexSearcher;
                try {
                    TermStates context = TermStates.build((IndexSearcher)searcher, (Term)term, (boolean)true);
                    if (context.docFreq() <= 0) continue;
                    TermStatistics statistic = searcher.termStatistics(term, context.docFreq(), context.totalTermFreq());
                    statistics.add(statistic);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            long docFreq = 0L;
            long totalTermFreq = 0L;
            for (TermStatistics statistic : statistics) {
                docFreq += statistic.docFreq();
                totalTermFreq += statistic.totalTermFreq();
            }
            if (docFreq == 0L) {
                return Optional.empty();
            }
            BytesRef bytesTerm = ((TermStatistics)statistics.getFirst()).term();
            TermStatistics result = new TermStatistics(bytesTerm, docFreq, totalTermFreq);
            return Optional.of(result);
        }

        CollectionStatistics collectionStatistics(String field) {
            return this.collStatisticsCache.computeIfAbsent(field, this::computeCollStatistics).orElse(null);
        }

        private Optional<CollectionStatistics> computeCollStatistics(String field) {
            try {
                long maxDoc = 0L;
                long docCount = 0L;
                long sumTotalTermFreq = 0L;
                long sumDocFreq = 0L;
                for (PreparedSearch preparedSearch : this.searches) {
                    CollectionStatistics statistic = preparedSearch.indexSearcher.collectionStatistics(field);
                    if (statistic == null) continue;
                    maxDoc += statistic.maxDoc();
                    docCount += statistic.docCount();
                    sumTotalTermFreq += statistic.sumTotalTermFreq();
                    sumDocFreq += statistic.sumDocFreq();
                }
                if (docCount == 0L) {
                    return Optional.empty();
                }
                return Optional.of(new CollectionStatistics(field, maxDoc, docCount, sumTotalTermFreq, sumDocFreq));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class FulltextResultCollector
    extends ScoredEntityResultCollector {
        private FulltextResultCollector(IndexQueryConstraints constraints, LongPredicate exclusionFilter) {
            super(constraints, exclusionFilter);
        }

        @Override
        protected String entityIdFieldKey() {
            return "__neo4j__lucene__fulltext__index__internal__id__";
        }
    }

    private static class StatsCachingIndexSearcher
    extends IndexSearcher {
        private final StatsCollector collector;

        StatsCachingIndexSearcher(IndexSearcher searcher, StatsCollector collector) {
            super(searcher.getTopReaderContext(), searcher.getExecutor());
            this.collector = collector;
        }

        public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) {
            return this.collector.termStatistics(term);
        }

        public CollectionStatistics collectionStatistics(String field) {
            return this.collector.collectionStatistics(field);
        }
    }
}

