/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.fulltext;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.schema.fulltext.IndexUpdateSink;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.storageengine.api.IndexEntryUpdate;

class EventuallyConsistentIndexUpdater
implements IndexUpdater {
    private final DatabaseIndex<? extends IndexReader> index;
    private final IndexUpdater indexUpdater;
    private final IndexUpdateSink indexUpdateSink;
    private final List<IndexEntryUpdate> updates = new ArrayList<IndexEntryUpdate>();

    EventuallyConsistentIndexUpdater(DatabaseIndex<? extends IndexReader> index, IndexUpdater indexUpdater, IndexUpdateSink indexUpdateSink) {
        this.index = index;
        this.indexUpdater = indexUpdater;
        this.indexUpdateSink = indexUpdateSink;
    }

    public void process(IndexEntryUpdate update) {
        this.updates.add(update);
    }

    public void close() {
        if (!this.updates.isEmpty()) {
            this.indexUpdateSink.enqueueTransactionBatchOfUpdates(this.index, this.indexUpdater, this.updates);
        }
    }
}

