/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.util.Objects;
import java.util.OptionalInt;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexConfigValidationWrapper;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfigUtils;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.kernel.api.vector.VectorSimilarityFunction;

public class VectorIndexConfig
extends IndexConfigValidationWrapper {
    private final VectorIndexVersion version;
    private final OptionalInt dimensions;
    private final VectorSimilarityFunction similarityFunction;
    private final boolean quantizationEnabled;
    private final HnswConfig hnswConfig;

    VectorIndexConfig(VectorIndexVersion version, IndexConfig config, ImmutableSortedMap<IndexSetting, Object> settings, ImmutableSortedSet<String> validSettingNames, ImmutableSortedSet<String> possibleValidSettingNames) {
        super(version.descriptor(), config, settings, validSettingNames, possibleValidSettingNames);
        this.version = version;
        this.dimensions = (OptionalInt)this.get(VectorIndexConfigUtils.DIMENSIONS);
        this.similarityFunction = (VectorSimilarityFunction)this.get(VectorIndexConfigUtils.SIMILARITY_FUNCTION);
        this.quantizationEnabled = (Boolean)this.get(VectorIndexConfigUtils.QUANTIZATION_ENABLED);
        this.hnswConfig = new HnswConfig((Integer)this.get(VectorIndexConfigUtils.HNSW_M), (Integer)this.get(VectorIndexConfigUtils.HNSW_EF_CONSTRUCTION));
    }

    public VectorIndexVersion version() {
        return this.version;
    }

    public OptionalInt dimensions() {
        return this.dimensions;
    }

    public VectorSimilarityFunction similarityFunction() {
        return this.similarityFunction;
    }

    public boolean quantizationEnabled() {
        return this.quantizationEnabled;
    }

    public HnswConfig hnsw() {
        return this.hnswConfig;
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.similarityFunction, this.quantizationEnabled, this.hnswConfig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VectorIndexConfig)) {
            return false;
        }
        VectorIndexConfig that = (VectorIndexConfig)((Object)o);
        return Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.similarityFunction, that.similarityFunction) && this.quantizationEnabled == that.quantizationEnabled && Objects.equals(this.hnswConfig, that.hnswConfig);
    }

    public record HnswConfig(int M, int efConstruction) {
        public static final HnswConfig DUMMY = new HnswConfig(16, 100);
    }
}

