/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.IndexWriterConfig;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProviderFactory;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.NonUniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.populator.UniqueLuceneIndexPopulator;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.participant.SchemaIndexMigrator;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class LuceneSchemaIndexProvider
extends SchemaIndexProvider {
    private final IndexStorageFactory indexStorageFactory;
    private final Log log;
    private Config config;
    private OperationalMode operationalMode;

    public LuceneSchemaIndexProvider(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, File storeDir, LogProvider logging, Config config, OperationalMode operationalMode) {
        super(LuceneSchemaIndexProviderFactory.PROVIDER_DESCRIPTOR, 1);
        File schemaIndexStoreFolder = this.getSchemaIndexStoreDirectory(storeDir);
        this.indexStorageFactory = this.buildIndexStorageFactory(fileSystem, directoryFactory, schemaIndexStoreFolder);
        this.config = config;
        this.operationalMode = operationalMode;
        this.log = logging.getLog(((Object)((Object)this)).getClass());
    }

    protected IndexStorageFactory buildIndexStorageFactory(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, File schemaIndexStoreFolder) {
        return new IndexStorageFactory(directoryFactory, fileSystem, schemaIndexStoreFolder);
    }

    public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexConfiguration indexConfiguration, IndexSamplingConfig samplingConfig) {
        SchemaIndex luceneIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create().withIndexConfig(indexConfiguration).withConfig(this.config)).withOperationalMode(this.operationalMode)).withSamplingConfig(samplingConfig).withIndexStorage(this.getIndexStorage(indexId))).withWriterConfig((Factory<IndexWriterConfig>)((Factory)IndexWriterConfigs::population)).build();
        if (luceneIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        if (indexConfiguration.isUnique()) {
            return new UniqueLuceneIndexPopulator(luceneIndex, descriptor);
        }
        return new NonUniqueLuceneIndexPopulator(luceneIndex, samplingConfig);
    }

    public IndexAccessor getOnlineAccessor(long indexId, IndexConfiguration indexConfiguration, IndexSamplingConfig samplingConfig) throws IOException {
        SchemaIndex luceneIndex = ((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create().withIndexConfig(indexConfiguration).withConfig(this.config)).withOperationalMode(this.operationalMode)).withSamplingConfig(samplingConfig).withIndexStorage(this.getIndexStorage(indexId))).build();
        luceneIndex.open();
        return new LuceneIndexAccessor(luceneIndex);
    }

    public void shutdown() throws Throwable {
    }

    public InternalIndexState getInitialState(long indexId) {
        PartitionedIndexStorage indexStorage = this.getIndexStorage(indexId);
        String failure = indexStorage.getStoredIndexFailure();
        if (failure != null) {
            return InternalIndexState.FAILED;
        }
        try {
            return this.indexIsOnline(indexStorage) ? InternalIndexState.ONLINE : InternalIndexState.POPULATING;
        }
        catch (IOException e) {
            this.log.error("Failed to open index:" + indexId + ", requesting re-population.", (Throwable)e);
            return InternalIndexState.POPULATING;
        }
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, LabelScanStoreProvider labelScanStoreProvider) {
        return new SchemaIndexMigrator(fs, (SchemaIndexProvider)this, labelScanStoreProvider);
    }

    public String getPopulationFailure(long indexId) throws IllegalStateException {
        String failure = this.getIndexStorage(indexId).getStoredIndexFailure();
        if (failure == null) {
            throw new IllegalStateException("Index " + indexId + " isn't failed");
        }
        return failure;
    }

    private PartitionedIndexStorage getIndexStorage(long indexId) {
        return this.indexStorageFactory.indexStorageOf(indexId, (Boolean)this.config.get(GraphDatabaseSettings.archive_failed_index));
    }

    private boolean indexIsOnline(PartitionedIndexStorage indexStorage) throws IOException {
        try (SchemaIndex index = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create().withIndexStorage(indexStorage)).build();){
            if (index.exists()) {
                index.open();
                boolean bl = index.isOnline();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

