/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.neo4j.index.impl.lucene.legacy.IndexIdentifier;

abstract class IndexReference {
    private final IndexIdentifier identifier;
    private final IndexSearcher searcher;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private boolean searcherIsClosed;
    private volatile boolean detached;

    public IndexReference(IndexIdentifier identifier, IndexSearcher searcher) {
        this.identifier = identifier;
        this.searcher = searcher;
    }

    abstract IndexWriter getWriter();

    abstract void dispose() throws IOException;

    abstract boolean checkAndClearStale();

    abstract void setStale();

    public IndexSearcher getSearcher() {
        return this.searcher;
    }

    public IndexIdentifier getIdentifier() {
        return this.identifier;
    }

    void incRef() {
        this.refCount.incrementAndGet();
    }

    void disposeSearcher() throws IOException {
        if (!this.searcherIsClosed) {
            this.searcher.getIndexReader().close();
            this.searcherIsClosed = true;
        }
    }

    void detachOrClose() throws IOException {
        if (this.refCount.get() == 0) {
            this.disposeSearcher();
        } else {
            this.detached = true;
        }
    }

    public synchronized boolean close() {
        try {
            if (this.searcherIsClosed || this.refCount.get() == 0) {
                return true;
            }
            boolean reallyClosed = false;
            if (this.refCount.decrementAndGet() <= 0 && this.detached) {
                this.disposeSearcher();
                reallyClosed = true;
            }
            return reallyClosed;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isClosed() {
        return this.searcherIsClosed;
    }

    boolean isDetached() {
        return this.detached;
    }
}

