/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TotalHitCountCollector;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.TaskControl;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.impl.schema.sampler.NonUniqueLuceneIndexSampler;
import org.neo4j.kernel.api.impl.schema.sampler.UniqueLuceneIndexSampler;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;

public class SimpleIndexReader
implements IndexReader {
    private PartitionSearcher partitionSearcher;
    private IndexConfiguration indexConfiguration;
    private final IndexSamplingConfig samplingConfig;
    private TaskCoordinator taskCoordinator;

    public SimpleIndexReader(PartitionSearcher partitionSearcher, IndexConfiguration indexConfiguration, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator) {
        this.partitionSearcher = partitionSearcher;
        this.indexConfiguration = indexConfiguration;
        this.samplingConfig = samplingConfig;
        this.taskCoordinator = taskCoordinator;
    }

    public IndexSampler createSampler() {
        TaskControl taskControl = this.taskCoordinator.newInstance();
        if (this.indexConfiguration.isUnique()) {
            return new UniqueLuceneIndexSampler(this.getIndexSearcher(), taskControl);
        }
        return new NonUniqueLuceneIndexSampler(this.getIndexSearcher(), taskControl, this.samplingConfig);
    }

    public PrimitiveLongIterator seek(Object value) {
        return this.query(LuceneDocumentStructure.newSeekQuery(value));
    }

    public PrimitiveLongIterator rangeSeekByNumberInclusive(Number lower, Number upper) {
        return this.query((Query)LuceneDocumentStructure.newInclusiveNumericRangeSeekQuery(lower, upper));
    }

    public PrimitiveLongIterator rangeSeekByString(String lower, boolean includeLower, String upper, boolean includeUpper) {
        return this.query(LuceneDocumentStructure.newRangeSeekByStringQuery(lower, includeLower, upper, includeUpper));
    }

    public PrimitiveLongIterator rangeSeekByPrefix(String prefix) {
        return this.query(LuceneDocumentStructure.newRangeSeekByPrefixQuery(prefix));
    }

    public PrimitiveLongIterator scan() {
        return this.query((Query)LuceneDocumentStructure.newScanQuery());
    }

    public PrimitiveLongIterator containsString(String exactTerm) {
        return this.query(LuceneDocumentStructure.newWildCardStringQuery(exactTerm));
    }

    public PrimitiveLongIterator endsWith(String suffix) {
        return this.query(LuceneDocumentStructure.newSuffixStringQuery(suffix));
    }

    public long countIndexedNodes(long nodeId, Object propertyValue) {
        TermQuery nodeIdQuery = new TermQuery(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId));
        Query valueQuery = LuceneDocumentStructure.newSeekQuery(propertyValue);
        BooleanQuery.Builder nodeIdAndValueQuery = new BooleanQuery.Builder().setDisableCoord(true);
        nodeIdAndValueQuery.add((Query)nodeIdQuery, BooleanClause.Occur.MUST);
        nodeIdAndValueQuery.add(valueQuery, BooleanClause.Occur.MUST);
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            this.getIndexSearcher().search((Query)nodeIdAndValueQuery.build(), (Collector)collector);
            return collector.getTotalHits();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.partitionSearcher.close();
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    protected PrimitiveLongIterator query(Query query) {
        try {
            DocValuesCollector docValuesCollector = new DocValuesCollector();
            this.getIndexSearcher().search(query, (Collector)docValuesCollector);
            return docValuesCollector.getValuesIterator("id");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private IndexSearcher getIndexSearcher() {
        return this.partitionSearcher.getIndexSearcher();
    }
}

