/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.Value;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum VectorSimilarityFunction {
    EUCLIDEAN{

        @Override
        public float[] maybeToValidVector(FloatingPointArray candidate) {
            if (candidate == null || candidate.isEmpty()) {
                return null;
            }
            int dimensions = candidate.length();
            float[] vector = new float[dimensions];
            for (int i = 0; i < dimensions; ++i) {
                float element = candidate.floatValue(i);
                if (!Float.isFinite(element)) {
                    return null;
                }
                vector[i] = element;
            }
            return vector;
        }

        @Override
        public float[] maybeToValidVector(List<Double> candidate) {
            if (candidate == null || candidate.isEmpty()) {
                return null;
            }
            int dimensions = candidate.size();
            float[] vector = new float[dimensions];
            for (int i = 0; i < dimensions; ++i) {
                float element;
                Double rawElement = candidate.get(i);
                if (rawElement == null || !Float.isFinite(element = rawElement.floatValue())) {
                    return null;
                }
                vector[i] = element;
            }
            return vector;
        }
    }
    ,
    COSINE{

        @Override
        public float[] maybeToValidVector(FloatingPointArray candidate) {
            if (candidate == null || candidate.isEmpty()) {
                return null;
            }
            int dimensions = candidate.length();
            float square = 0.0f;
            float[] vector = new float[dimensions];
            for (int i = 0; i < candidate.length(); ++i) {
                float element = candidate.floatValue(i);
                if (!Float.isFinite(element)) {
                    return null;
                }
                square += element * element;
                vector[i] = element;
            }
            if (square <= 0.0f || !Float.isFinite(square)) {
                return null;
            }
            return vector;
        }

        @Override
        public float[] maybeToValidVector(List<Double> candidate) {
            if (candidate == null || candidate.isEmpty()) {
                return null;
            }
            int dimensions = candidate.size();
            float square = 0.0f;
            float[] vector = new float[dimensions];
            for (int i = 0; i < dimensions; ++i) {
                float element;
                Double rawElement = candidate.get(i);
                if (rawElement == null || !Float.isFinite(element = rawElement.floatValue())) {
                    return null;
                }
                square += element * element;
                vector[i] = element;
            }
            if (square <= 0.0f || !Float.isFinite(square)) {
                return null;
            }
            return vector;
        }
    };

    public static final EnumSet<VectorSimilarityFunction> SUPPORTED;

    public static VectorSimilarityFunction fromName(String name) {
        try {
            return VectorSimilarityFunction.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            IllegalArgumentException exception = new IllegalArgumentException("'%s' is an unsupported vector similarity function. Supported: %s".formatted(name, SUPPORTED));
            exception.addSuppressed(e);
            throw exception;
        }
    }

    public final float[] maybeToValidVector(Value candidate) {
        if (!(candidate instanceof FloatingPointArray)) {
            return null;
        }
        FloatingPointArray array = (FloatingPointArray)candidate;
        return this.maybeToValidVector(array);
    }

    public abstract float[] maybeToValidVector(FloatingPointArray var1);

    public abstract float[] maybeToValidVector(List<Double> var1);

    public float compare(float[] vector1, float[] vector2) {
        return this.toLucene().compare(vector1, vector2);
    }

    final org.apache.lucene.index.VectorSimilarityFunction toLucene() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case EUCLIDEAN -> org.apache.lucene.index.VectorSimilarityFunction.EUCLIDEAN;
            case COSINE -> org.apache.lucene.index.VectorSimilarityFunction.COSINE;
        };
    }

    static {
        SUPPORTED = EnumSet.allOf(VectorSimilarityFunction.class);
    }
}

